/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.eref;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Client;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ErrorCode;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ExtractionException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.FileData;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.util.Result;
import ch.dvbern.tax.ju.JuModelConstants;
import ch.dvbern.tax.ju.presentation.common.eref.BankAccounts;
import ch.dvbern.tax.ju.presentation.common.eref.Clients;
import ch.dvbern.tax.ju.presentation.common.eref.Expenses;
import ch.dvbern.tax.ju.presentation.common.eref.LiabilityAccounts;
import ch.dvbern.tax.ju.presentation.common.eref.Securities;
import ch.dvbern.tax.ju.presentation.common.eref.TSUtils;
import ch.dvbern.tax.ju.transfer.TransferMessage;
import ch.dvbern.tax.ju.utils.TaxStatementModelMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSFileImporter {
    private static final Logger LOG = LoggerFactory.getLogger(TSFileImporter.class);
    private final Map<String, ModelItemDTO> dataModel;
    private final @NonNull Map<String, LogicModelItem> logicModel;
    private final @NonNull Consumer<Map<String, ModelItemDTO>> updater;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap protectedData;
    private final byte[] pdfBytes;
    private final byte[] xmlBytes;
    private final @NonNull String fileName;
    private final @NonNull Steuerauszug steuerauszug;
    private long steuerJahr;
    private Securities securities;
    private BankAccounts bankAccounts;
    private Clients clients;
    private LiabilityAccounts liabilityAccounts;
    private Expenses expenses;

    public TSFileImporter(@NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, @NonNull Consumer<Map<String, ModelItemDTO>> updater, @NonNull Steuerauszug steuerauszug, @NonNull String fileName, byte[] xmlBytes, byte[] pdfBytes) {
        this.dataModel = Objects.requireNonNull(dataModel);
        this.logicModel = Objects.requireNonNull(logicModel);
        this.updater = Objects.requireNonNull(updater);
        this.protectedData = new LogicModelItem.ProtectedMap(dataModel, true);
        this.fileName = Objects.requireNonNull(fileName);
        this.steuerauszug = Objects.requireNonNull(steuerauszug);
        this.xmlBytes = Objects.requireNonNull(xmlBytes);
        this.pdfBytes = Objects.requireNonNull(pdfBytes);
        this.securities = new Securities(logicModel, dataModel, updater);
        this.bankAccounts = new BankAccounts(logicModel, dataModel, updater, this.steuerJahr);
        this.clients = new Clients(logicModel, dataModel, updater);
        this.liabilityAccounts = new LiabilityAccounts(logicModel, dataModel, updater);
        this.expenses = new Expenses(logicModel, dataModel, updater);
    }

    public void execute() throws ExtractionException {
        LOG.info("EREF: beginning file import");
        this.importFileToTemporaryModel();
        LOG.info("EREF: end file import");
        LOG.info("EREF: beginning model import");
        this.importTemporaryModelToEffectiveModel();
        LOG.info("EREF: end model import");
    }

    public void importFileToTemporaryModel() {
        if (this.xmlBytes == null) {
            throw new ExtractionException(ErrorCode.INVALID_XML, null);
        }
        LogicModelItem.TableItem taxStatementsTable = (LogicModelItem.TableItem)this.logicModel.get(JuModelConstants.TAX_STATEMENTS.toExternalForm());
        if (TSUtils.isDuplicateESteuerauszug(this.protectedData, JuModelConstants.TAX_STATEMENTS, Objects.requireNonNull(this.steuerauszug.getId()))) {
            throw new ExtractionException(ErrorCode.DUPLICATE_UPLOAD, null);
        }
        this.steuerJahr = this.getSteuerjahrFromModel(this.protectedData);
        if (TSUtils.isWrongYearESteuerauszug(Objects.requireNonNull(this.steuerauszug), this.steuerJahr)) {
            throw new ExtractionException(ErrorCode.WRONG_TAX_PERIOD, null);
        }
        int taxStatementIdx = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)this.protectedData, (LogicModelItem.TableItem)taxStatementsTable, (String)JuModelConstants.TAX_STATEMENTS.toExternalForm());
        DMK taxStatementRow = JuModelConstants.TAX_STATEMENTS.toTableRow((long)taxStatementIdx);
        this.clients.writeClientsTemporaryModel(this.steuerauszug, this.protectedData, taxStatementRow);
        this.bankAccounts.writeBankaccountsTemporaryModel(this.steuerauszug, this.protectedData, taxStatementRow);
        this.securities.writeSecuritiesTemporaryModel(this.steuerauszug, this.protectedData, taxStatementRow);
        this.expenses.writeExpensesTemporaryModel(this.steuerauszug, this.protectedData, taxStatementRow);
        this.liabilityAccounts.writeLiabilityaccountsTemporaryModel(this.steuerauszug, this.protectedData, taxStatementRow);
        this.updater.accept(this.getTaxStatementItems(taxStatementRow).getChanges());
    }

    private void importTemporaryModelToEffectiveModel() {
        ArrayList<Result<TransferMessage, Optional<TransferMessage>>> messages = new ArrayList<Result<TransferMessage, Optional<TransferMessage>>>();
        Set rowDmks = JuModelConstants.TAXSTATEMENT_TABLE_DMK.findRowDMKs(this.dataModel).orElse(Collections.emptySet());
        for (DMK row : rowDmks) {
            if (this.alreadyTransferred(row)) continue;
            messages.addAll(this.bankAccounts.transferKonten(row));
            messages.addAll(this.securities.transferSecurities(row));
            messages.addAll(this.liabilityAccounts.transferLiabilityAccountsrealModel(row));
            messages.addAll(this.expenses.transferExpenses(row));
            this.updater.accept(new TaxStatementModelMap(row).add("StateItem", true).getChanges());
        }
        this.updater.accept(new TaxStatementModelMap(DMK.parse((String)"TaxStatement")).getChanges());
    }

    private boolean alreadyTransferred(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        Boolean boolVal = (Boolean)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTEMENT_TABLE_STATUS, srcRow);
        boolean transferred = boolVal != null && boolVal != false;
        return transferred;
    }

    private long getSteuerjahrFromModel(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap protectedData) {
        ModelItemDTO steuerJahrModelItem = protectedData.get((Object)"Stammdaten.Declaration.PeriodeTaxation");
        if (null == steuerJahrModelItem || null == steuerJahrModelItem.getValue()) {
            throw new ExtractionException(ErrorCode.INTERNAL_ERROR, null);
        }
        return (Long)steuerJahrModelItem.getValue();
    }

    private TaxStatementModelMap getTaxStatementItems(@NonNull DMK rowDmk) {
        TaxStatementModelMap newTaxModelItems = new TaxStatementModelMap(rowDmk);
        newTaxModelItems.add("Id", this.steuerauszug.getId());
        newTaxModelItems.add("CreationDate", this.steuerauszug.getCreationDate());
        newTaxModelItems.add("TaxPeriod", this.steuerauszug.getTaxPeriod());
        newTaxModelItems.add("PeriodFrom", this.steuerauszug.getPeriodFrom());
        newTaxModelItems.add("PeriodTo", this.steuerauszug.getPeriodTo());
        newTaxModelItems.add("Country", this.steuerauszug.getCountry());
        newTaxModelItems.add("Canton", TSUtils.castString(this.steuerauszug.getCanton()));
        newTaxModelItems.add("TotalTaxValue", this.steuerauszug.getTotalTaxValue());
        newTaxModelItems.add("TotalGrossRevenueA", this.steuerauszug.getTotalGrossRevenueA());
        newTaxModelItems.add("TotalGrossRevenueACanton", this.steuerauszug.getTotalGrossRevenueACanton());
        newTaxModelItems.add("TotalGrossRevenueB", this.steuerauszug.getTotalGrossRevenueB());
        newTaxModelItems.add("TotalGrossRevenueBCanton", this.steuerauszug.getTotalGrossRevenueBCanton());
        newTaxModelItems.add("TotalWithHoldingTaxClaim", this.steuerauszug.getTotalWithHoldingTaxClaim());
        newTaxModelItems.add("Lei", this.steuerauszug.getLei());
        newTaxModelItems.add("OrganisationName", this.steuerauszug.getOrganisationName());
        newTaxModelItems.add("FirstClientNumber", this.getFirstClientNumber(this.steuerauszug.getClients()));
        newTaxModelItems.add("Uid", this.steuerauszug.getUid());
        newTaxModelItems.add("TaxStatementFileName", this.fileName);
        newTaxModelItems.add("ESteuerauszugXml", new FileData("taxStatementXml", this.fileName, (long)this.xmlBytes.length, "text/xml", this.xmlBytes));
        newTaxModelItems.add("TaxStatementPdf", new FileData("taxStatementPdf", this.fileName, (long)this.pdfBytes.length, "application/pdf", this.pdfBytes));
        return newTaxModelItems;
    }

    private @NonNull String getFirstClientNumber(@Nullable List<Client> clients) {
        if (clients == null || clients.isEmpty()) {
            return "";
        }
        String clientNumber = clients.get(0).getClientNumber();
        return clientNumber != null ? clientNumber : "";
    }
}

