/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.eref;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ErrorCode;
import ch.dvbern.dvbtax.esteuerauszugextractor.exception.ExtractionException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.ResourceLineIterator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.util.Result;
import ch.dvbern.tax.ju.JuModelConstants;
import ch.dvbern.tax.ju.transfer.Category;
import ch.dvbern.tax.ju.transfer.TransferMessage;
import ch.dvbern.tax.ju.transfer.esteuerauszug.DupeMode;
import jakarta.xml.bind.annotation.XmlEnum;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TSUtils.class);
    public static final String CURRENCY_FILEPATH = "ch/dvbern/tax/ju/res/resources/monnaie.txt";
    public static Map<String, Long> CURRENCY_MAP;
    public static Long CURRENCY_OTHER;

    public static <T> @Nullable T extractValueFromModel(@NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, @NonNull LMK lmk, @NonNull DMK row) {
        Objects.requireNonNull(lmk);
        Objects.requireNonNull(row);
        Objects.requireNonNull(logicModel.get(lmk.toExternalForm()), "LMK does not exist in logicmodel: " + String.valueOf(lmk));
        DMK dmk = row.merge(lmk);
        ModelItemDTO modelItemDTO = dataModel.get(dmk.toExternalForm());
        if (modelItemDTO == null) {
            return null;
        }
        return (T)modelItemDTO.getValue();
    }

    public static long getSteuerjahrFromModel(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap protectedData) {
        ModelItemDTO steuerJahrModelItem = protectedData.get((Object)"Stammdaten.Declaration.PeriodeTaxation");
        if (null == steuerJahrModelItem || null == steuerJahrModelItem.getValue()) {
            throw new ExtractionException(ErrorCode.INTERNAL_ERROR, null);
        }
        return (Long)steuerJahrModelItem.getValue();
    }

    public static boolean isEsteuerauszug(@NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, DMK tableDMK, DMK row) {
        Boolean isESteuerauszug = (Boolean)TSUtils.extractValueFromModel(logicModel, dataModel, tableDMK.append("IsESteuerauszug").toLMK(), row);
        if (isESteuerauszug != null) {
            return isESteuerauszug;
        }
        return false;
    }

    public static boolean hasGrossRevenueA(@Nullable Double grossRevenueA) {
        boolean result = grossRevenueA != null && grossRevenueA > 0.0;
        return result;
    }

    public static Double divisionOrDefault(@Nullable Double dividend, @Nullable Double divisor, Double defaultValue) {
        return dividend != null && divisor != null && divisor != 0.0 ? dividend / divisor : defaultValue;
    }

    public static double getOrZero(@Nullable Double value) {
        return value != null ? value : 0.0;
    }

    public static boolean isWrongYearESteuerauszug(@NonNull Steuerauszug steuerauszug, long steuerJahr) {
        Objects.requireNonNull(steuerauszug.getTaxPeriod());
        return (long)steuerauszug.getTaxPeriod().intValue() != steuerJahr;
    }

    public static @NonNull boolean isDuplicateESteuerauszug(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap protectedData, @NonNull DMK tableDMK, @NonNull String givenEauszugIdentifier) {
        Set rowDmks = EngineUtil.findRowDMKs((Map)protectedData, (DMK)tableDMK);
        for (DMK rowDMK : rowDmks) {
            String alreadyExistingEntryIdentifier = String.valueOf(protectedData.get((Object)rowDMK.merge(JuModelConstants.TAX_STATEMENTS_ID.toLMK()).toExternalForm()));
            if (!Objects.requireNonNull(alreadyExistingEntryIdentifier).replace("\\s", "").equalsIgnoreCase(Objects.requireNonNull(givenEauszugIdentifier).replace("\\s", ""))) continue;
            return true;
        }
        return false;
    }

    public static boolean isStateMissingValue(@NonNull ModelItemDTO modelItemDTO) {
        return modelItemDTO.getState() == 3;
    }

    public static boolean isStateError(@NonNull ModelItemDTO modelItemDTO) {
        return modelItemDTO.getState() == 4;
    }

    public static boolean isStateOkOrWarning(@NonNull ModelItemDTO modelItemDTO) {
        return modelItemDTO.getState() == 1 || modelItemDTO.getState() == 2;
    }

    public static @Nullable Long asLong(@Nullable Object value) {
        Double dbl = TSUtils.asDouble(value);
        if (dbl == null) {
            return null;
        }
        return Math.round(dbl);
    }

    public static @Nullable Double asDouble(@Nullable Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException("Falscher Datentyp. Erwarte Double oder BigDecimal.");
    }

    public static @Nullable String asString(@Nullable Object value) {
        return value != null ? String.valueOf(value) : null;
    }

    public static @Nullable Integer castInt(@Nullable BigInteger bigInt) {
        return bigInt == null ? null : Integer.valueOf(bigInt.intValue());
    }

    public static @Nullable String castString(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof XmlEnum) {
            return String.valueOf(((XmlEnum)obj).value());
        }
        return obj.toString();
    }

    public static boolean identifiersMatch(@Nullable String givenEauszugIdentifier, @Nullable String alreadyExistingEntryIdentifier) {
        if (givenEauszugIdentifier == null || alreadyExistingEntryIdentifier == null) {
            return false;
        }
        return StringUtils.deleteWhitespace((String)givenEauszugIdentifier).equalsIgnoreCase(StringUtils.deleteWhitespace((String)alreadyExistingEntryIdentifier));
    }

    public static @NonNull Pair<DMK, String> getDuplicateEntry(@NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, @NonNull DMK tableDMK, @NonNull LMK givenIdentifier, @Nullable String givenEauszugIdentifier) {
        if (givenEauszugIdentifier == null) {
            return Pair.of(null, null);
        }
        Set rowDmks = tableDMK.findRowDMKs(dataModel).orElse(Collections.emptySet());
        for (DMK row : rowDmks) {
            String alreadyExistingEntryIdentifier;
            if (TSUtils.isEsteuerauszug(logicModel, dataModel, tableDMK, row) || !TSUtils.identifiersMatch(givenEauszugIdentifier, alreadyExistingEntryIdentifier = TSUtils.asString(TSUtils.extractValueFromModel(logicModel, dataModel, givenIdentifier, row)))) continue;
            return Pair.of((Object)row, (Object)alreadyExistingEntryIdentifier);
        }
        return Pair.of(null, null);
    }

    public static Long getCurrencyCode(String waehrung) {
        return CURRENCY_MAP.get(waehrung);
    }

    public static Long getCurrencyOther() {
        return CURRENCY_OTHER;
    }

    public static @NonNull DupeMode getDupeMode(@NonNull Map<String, ModelItemDTO> dataModel, @Nullable DMK duplicateEntry) {
        if (duplicateEntry == null) {
            return DupeMode.NO_DUPLICATE;
        }
        if (TSUtils.isStateOkOrWarning(dataModel.get(duplicateEntry.toExternalForm()))) {
            return DupeMode.REPLACE;
        }
        if (TSUtils.isStateMissingValue(dataModel.get(duplicateEntry.toExternalForm()))) {
            return DupeMode.REPLACE;
        }
        if (TSUtils.isStateError(dataModel.get(duplicateEntry.toExternalForm()))) {
            return DupeMode.REPLACE;
        }
        return DupeMode.NO_DUPLICATE;
    }

    public static <T, R> @Nullable R extract(@Nullable T t, Function<T, R> extractor) {
        if (t == null) {
            return null;
        }
        return extractor.apply(t);
    }

    @SafeVarargs
    public static <T> @Nullable T coalesce(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static void enableToplevelCheckbox(@NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, @NonNull Consumer<Map<String, ModelItemDTO>> updater, @NonNull LMK lmk) {
        Objects.requireNonNull(lmk);
        DMK dmk = lmk.toRootlevelDMK();
        Boolean enabled = (Boolean)TSUtils.extractValueFromModel(logicModel, dataModel, lmk, DMK.root());
        if (enabled != null && enabled.booleanValue()) {
            return;
        }
        ModelItemDTO checkedValue = new ModelItemDTO((Object)Boolean.TRUE, 1).cloneTouched();
        updater.accept(Collections.singletonMap(dmk.toExternalForm(), checkedValue));
    }

    public static @NonNull DMK createNewRowIfNotExisting(@NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, @NonNull DMK newRow, @Nullable DMK existingRow) {
        if (existingRow != null) {
            return existingRow;
        }
        return TSUtils.createNewRowDMK(logicModel, dataModel, newRow);
    }

    public static <T> Result<TransferMessage, Optional<TransferMessage>> handleTransferIfNeeded(@NonNull Map<String, ModelItemDTO> dataModel, @NonNull Pair<DMK, String> existingDuplicate, @NonNull DMK newEntry, @NonNull Category category, @NonNull Function<DMK, Result<TransferMessage, T>> builderFuncton, @NonNull BiConsumer<T, DMK> transferMethod) {
        DupeMode dupeMode = TSUtils.getDupeMode(dataModel, (DMK)existingDuplicate.getLeft());
        switch (dupeMode) {
            case REPLACE: {
                TransferMessage transferInfoMessage = new TransferMessage(category, (String)existingDuplicate.getRight(), dupeMode.getReason(category), (Serializable)existingDuplicate.getRight());
                return builderFuncton.apply(newEntry).ifOk(dto -> transferMethod.accept(dto, (DMK)existingDuplicate.getLeft())).map(msg -> Optional.of(transferInfoMessage));
            }
            case KEEP_OLD: {
                TransferMessage transferInfoMessage = new TransferMessage(category, (String)existingDuplicate.getRight(), dupeMode.getReason(category), (Serializable)existingDuplicate.getRight());
                return Result.error((Object)transferInfoMessage);
            }
        }
        return builderFuncton.apply(newEntry).ifOk(dto -> transferMethod.accept(dto, (DMK)existingDuplicate.getLeft())).map(msg -> Optional.empty());
    }

    private static @NonNull DMK createNewRowDMK(@NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, @NonNull DMK tableDMK) {
        Objects.requireNonNull(tableDMK);
        LogicModelItem.TableItem tableItem = (LogicModelItem.TableItem)logicModel.get(tableDMK.toExternalForm());
        Objects.requireNonNull(tableItem, "Table not found: " + String.valueOf(tableDMK));
        int rowIdx = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)new LogicModelItem.ProtectedMap(dataModel, true), (LogicModelItem.TableItem)tableItem, (DMK)tableDMK);
        DMK newRow = tableDMK.toTableRow((long)rowIdx);
        return newRow;
    }

    static {
        CURRENCY_OTHER = 48L;
        InputStream currencyResource = TSUtils.class.getClassLoader().getResourceAsStream(CURRENCY_FILEPATH);
        HashMap<String, Long> currencyMap = new HashMap<String, Long>();
        try (InputStreamReader is = new InputStreamReader(currencyResource, StandardCharsets.UTF_8);){
            ResourceLineIterator itr = new ResourceLineIterator((Reader)is);
            while (itr.hasNext()) {
                String[] tokens = itr.splitNext(2);
                Long key = Long.valueOf(tokens[0]);
                String designation = tokens[1].substring(1, 4);
                currencyMap.put(designation, key);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("EREF: impossible to map currency");
        }
        CURRENCY_MAP = Collections.unmodifiableMap(currencyMap);
    }
}

