/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.imports;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.imports.ImportContext;
import ch.dvbern.tax.common.presentation.common.imports.ImportException;
import ch.dvbern.tax.common.presentation.common.imports.TaxFileImporter;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JuTaxFileImporter
extends TaxFileImporter {
    private static final Logger LOG = LoggerFactory.getLogger(JuTaxFileImporter.class);
    private static final Long TAX_YEAR_EXPECTED = ApplicationConfig.getInstance().getVorjahr();
    private static final Boolean IMMEUBLE_NON_VENDU = Boolean.FALSE;
    private static final String TAX_YEAR_ERROR_CODE = "error.import.steuerjahr";
    private static final Map<String, String> TITRES_DATE_CLOTURE;
    private static final Map<String, String> ASSURANCE_VIE_ECHUE;
    private static final Map<String, String> IMMEUBLE_VENDU;
    private static final Map<String, String> IMMEUBLE_AGE;

    public JuTaxFileImporter(ImportContext ctx) {
        super(ctx);
    }

    protected void importOldModelItems() throws ImportException {
        Object value;
        Long taxYear = null;
        ModelItemDTO taxYearItem = (ModelItemDTO)this.getImportContext().getOldDataModel().get("Stammdaten.Declaration.PeriodeTaxation");
        if (taxYearItem != null && (value = taxYearItem.getValue()) != null) {
            if (value instanceof Long) {
                taxYear = (Long)value;
            } else {
                try {
                    taxYear = Long.valueOf(value.toString());
                }
                catch (Exception e) {
                    LOG.warn("tax year conversion failed", (Throwable)e);
                    taxYear = null;
                }
            }
        }
        if (!TAX_YEAR_EXPECTED.equals(taxYear)) {
            throw new ImportException(TAX_YEAR_ERROR_CODE);
        }
        super.importOldModelItems();
    }

    protected void storeInNewModel(String key, ModelItemDTO value) throws ImportException {
        String logicModelKey = EngineUtil.removeTableIndices((String)key);
        this.dontImportOldTitres(key, logicModelKey);
        this.dontImportCurrentAssuranceVie(key, logicModelKey);
        this.dontImportSoldImmeubles(key, logicModelKey);
        value = this.incrementAgeImmeuble(key, value, logicModelKey);
        value = this.determineEtatCivil(key, value);
        value = this.changementMonsieur(key, value);
        value = this.changementMadame(key, value);
        super.storeInNewModel(key, value);
    }

    private ModelItemDTO changementMadame(String key, ModelItemDTO value) {
        ModelItemDTO mi;
        if (key.equals("Stammdaten.Madame.ChangementOuiNon") && (mi = (ModelItemDTO)this.getImportContext().getOldDataModel().get(key)) != null) {
            value = value.clone((Object)Boolean.FALSE);
        }
        return value;
    }

    private ModelItemDTO changementMonsieur(String key, ModelItemDTO value) {
        ModelItemDTO mi;
        if (key.equals("Stammdaten.Monsieur.ChangementOuiNon") && (mi = (ModelItemDTO)this.getImportContext().getOldDataModel().get(key)) != null) {
            value = value.clone((Object)Boolean.FALSE);
        }
        return value;
    }

    private ModelItemDTO determineEtatCivil(String key, ModelItemDTO value) {
        if (key.equals("Stammdaten.SituationContribuable.MariageDansAnneeOuiNon")) {
            ModelItemDTO mi = (ModelItemDTO)this.getImportContext().getOldDataModel().get(key);
            String etatCivil = "Stammdaten.SituationContribuable.EtatCivil";
            ModelItemDTO miMarie = (ModelItemDTO)this.getImportContext().getOldDataModel().get("Stammdaten.SituationContribuable.EtatCivil");
            if (mi != null) {
                value = (Boolean)mi.getValue() != false ? value.clone((Object)Boolean.FALSE) : value.clone(null);
            }
            if (miMarie != null && (Long)miMarie.getValue() == 2L) {
                value = value.clone((Object)Boolean.FALSE);
            }
        }
        return value;
    }

    private ModelItemDTO incrementAgeImmeuble(String key, ModelItemDTO value, String logicModelKey) {
        for (String current : IMMEUBLE_AGE.keySet()) {
            Object ageObj;
            if (!logicModelKey.startsWith(current)) continue;
            String lmkAufloesung = IMMEUBLE_AGE.get(current);
            String dmkAufloesung = EngineUtil.mergeModelKey((String)lmkAufloesung, (String)key);
            ModelItemDTO mi = (ModelItemDTO)this.getImportContext().getOldDataModel().get(dmkAufloesung);
            if (mi == null || mi.getValue() == null || !((ageObj = mi.getValue()) instanceof Long)) continue;
            Long age = (Long)ageObj;
            value = value.clone((Object)(age + 1L));
        }
        return value;
    }

    private void dontImportSoldImmeubles(String key, String logicModelKey) {
        for (String current : IMMEUBLE_VENDU.keySet()) {
            Boolean b;
            Object vente;
            if (!logicModelKey.startsWith(current)) continue;
            String lmkAufloesung = IMMEUBLE_VENDU.get(current);
            String dmkAufloesung = EngineUtil.mergeModelKey((String)lmkAufloesung, (String)key);
            ModelItemDTO mi = (ModelItemDTO)this.getImportContext().getOldDataModel().get(dmkAufloesung);
            if (mi == null || mi.getValue() == null || !((vente = mi.getValue()) instanceof Boolean) || (b = (Boolean)vente).booleanValue() == IMMEUBLE_NON_VENDU.booleanValue()) continue;
            return;
        }
    }

    private void dontImportCurrentAssuranceVie(String key, String logicModelKey) {
        for (String current : ASSURANCE_VIE_ECHUE.keySet()) {
            Number n;
            Object verfall;
            if (!logicModelKey.startsWith(current)) continue;
            String lmkAufloesung = ASSURANCE_VIE_ECHUE.get(current);
            String dmkAufloesung = EngineUtil.mergeModelKey((String)lmkAufloesung, (String)key);
            ModelItemDTO mi = (ModelItemDTO)this.getImportContext().getOldDataModel().get(dmkAufloesung);
            if (mi == null || mi.getValue() == null || !((verfall = mi.getValue()) instanceof Number) || (n = (Number)verfall).longValue() != (long)(TAX_YEAR_EXPECTED.intValue() + 1)) continue;
            return;
        }
    }

    private void dontImportOldTitres(String key, String logicModelKey) {
        for (String current : TITRES_DATE_CLOTURE.keySet()) {
            Number n;
            if (!logicModelKey.startsWith(current)) continue;
            String lmkAufloesung = TITRES_DATE_CLOTURE.get(current);
            String dmkAufloesung = EngineUtil.mergeModelKey((String)lmkAufloesung, (String)key);
            ModelItemDTO mi = (ModelItemDTO)this.getImportContext().getOldDataModel().get(dmkAufloesung);
            if (mi == null || mi.getValue() == null) continue;
            Object verfall = mi.getValue();
            if (verfall instanceof Date) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)verfall);
                if (cal.get(1) > TAX_YEAR_EXPECTED.intValue()) continue;
                return;
            }
            if (!(verfall instanceof Number) || !((n = (Number)verfall).doubleValue() <= 0.0)) continue;
            return;
        }
    }

    static {
        HashMap<String, String> wsVerfall = new HashMap<String, String>();
        wsVerfall.put("Wertschriften.Konti.Konti", "Wertschriften.Konti.Konti.DatumAufloesung");
        wsVerfall.put("Wertschriften.Aktien.Aktien", "Wertschriften.Aktien.Aktien.AnzahlEndeJahr");
        wsVerfall.put("Wertschriften.Obligationen.Obligationen", "Wertschriften.Obligationen.Obligationen.DatumVerfall");
        wsVerfall.put("Wertschriften.Darlehen.Darlehen", "Wertschriften.Darlehen.Darlehen.DatumVerfall");
        wsVerfall.put("Wertschriften.Diverse.Diverse", "Wertschriften.Diverse.Diverse.DatumVerfall");
        TITRES_DATE_CLOTURE = Collections.unmodifiableMap(wsVerfall);
        HashMap<String, String> assurancesEchues = new HashMap<String, String>();
        assurancesEchues.put("Vermoegen.Lebensversicherungen.Lebensversicherungen", "Vermoegen.Lebensversicherungen.Lebensversicherungen.Ablaufjahr");
        ASSURANCE_VIE_ECHUE = Collections.unmodifiableMap(assurancesEchues);
        HashMap<String, String> immeubleVendu = new HashMap<String, String>();
        immeubleVendu.put("Liegenschaft.Immeubles.TableImmeubles", "Liegenschaft.Immeubles.TableImmeubles.DonneesRef.QuestionVenteImmeuble");
        IMMEUBLE_VENDU = Collections.unmodifiableMap(immeubleVendu);
        immeubleVendu = new HashMap();
        immeubleVendu.put("Liegenschaft.Immeubles.TableImmeubles.DonneesRef.AnneeConstruction", "Liegenschaft.Immeubles.TableImmeubles.DonneesRef.AnneeConstruction");
        IMMEUBLE_AGE = Collections.unmodifiableMap(immeubleVendu);
    }
}

