/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer;

import ch.dvbern.tax.ju.transfer.Category;
import ch.dvbern.tax.ju.transfer.Reason;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TransferMessage
implements Serializable {
    private static final long serialVersionUID = -246663465986227381L;
    private final @NonNull Category category;
    private final @NonNull String entryName;
    private final @NonNull Reason reason;
    private final @NonNull Serializable[] args;

    public TransferMessage(@NonNull Category category, @NonNull String entryName, @NonNull Reason reason, Serializable ... args) {
        this.category = Objects.requireNonNull(category);
        this.entryName = Objects.requireNonNull(entryName);
        this.reason = Objects.requireNonNull(reason);
        this.args = Objects.requireNonNull(args);
        if (args.length != reason.getArgNames().size()) {
            throw new IllegalArgumentException("Expected arguments: " + String.valueOf(reason.getArgNames()) + ", actual: " + Arrays.toString(this.args));
        }
    }

    public @NonNull Category getCategory() {
        return this.category;
    }

    public @NonNull String getEntryName() {
        return this.entryName;
    }

    public @NonNull Reason getReason() {
        return this.reason;
    }

    public @NonNull Serializable[] getArgs() {
        return this.args;
    }
}

