/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto;

import ch.dvbern.tax.ju.JuUtil;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CodeDI
implements Serializable {
    private static final long serialVersionUID = 8677674906153908418L;
    public static final String INPUT_PATTERN_REGEXP = "^[\\p{Alnum}- ]*$";
    public static final String VALIDATION_PATTERN_REGEXP = "^[\\p{Alnum}-]+$";
    public static final Pattern VALIDATION_PATTERN = Pattern.compile("^[\\p{Alnum}-]+$");
    private static final Pattern SPACE_REMOVER = Pattern.compile("\\p{Space}");
    private static final Pattern DASH_REMOVER = Pattern.compile("[^A-Z0-9]");
    private final String text;
    private final String normalized;

    public CodeDI(@NonNull String codeDIText) {
        Objects.requireNonNull(codeDIText);
        String clean = this.clean(codeDIText);
        this.validateNormalized(clean);
        this.text = clean;
        this.normalized = this.normalize(clean);
    }

    private String clean(@NonNull String codeDIText) {
        String clean = StringUtils.trimToEmpty((String)codeDIText);
        clean = StringUtils.trimToEmpty((String)SPACE_REMOVER.matcher(codeDIText).replaceAll(""));
        clean = clean.toUpperCase(JuUtil.APPLICATION_LOCALE);
        return clean;
    }

    private String normalize(@NonNull String codeDIText) {
        String normalized = StringUtils.trimToEmpty((String)codeDIText);
        normalized = StringUtils.trimToEmpty((String)DASH_REMOVER.matcher(normalized).replaceAll(""));
        return normalized;
    }

    private void validateNormalized(@NonNull String codeDIText) {
        Objects.requireNonNull(codeDIText);
        if (!VALIDATION_PATTERN.matcher(codeDIText).matches()) {
            throw new IllegalArgumentException("Not a valid CodeDI: " + codeDIText);
        }
    }

    public String asText() {
        return this.text;
    }

    public String getNormalized() {
        return this.normalized;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.text).build();
    }
}

