/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto;

import java.util.HashMap;
import java.util.Map;

public enum IdentificationLevel {
    VERIFIED("verified"),
    NOT_VERIFIED("notverified");

    private String value;
    private static final Map<String, IdentificationLevel> lookup;

    private IdentificationLevel(String value) {
        this.value = value;
    }

    public static IdentificationLevel get(String value) {
        if (value == null) {
            return null;
        }
        IdentificationLevel element = lookup.get(value);
        if (element == null) {
            throw new IllegalArgumentException("Can't parse the value '" + value + "' to an IdentificationLevel enum");
        }
        return element;
    }

    public static boolean isVerified(IdentificationLevel identificationLevel) {
        return VERIFIED.equals((Object)identificationLevel);
    }

    public static boolean isNotVerified(IdentificationLevel identificationLevel) {
        return NOT_VERIFIED.equals((Object)identificationLevel);
    }

    public String getValue() {
        return this.value;
    }

    static {
        lookup = new HashMap<String, IdentificationLevel>();
        for (IdentificationLevel env : IdentificationLevel.values()) {
            lookup.put(env.getValue(), env);
        }
    }
}

