/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto;

import ch.dvbern.tax.common.presentation.bd.AuthenticationData;
import ch.dvbern.tax.ju.transfer.dto.IdentificationLevel;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.transfer.dto.PrefillableField;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JuAuthenticationData
implements AuthenticationData {
    private static final long serialVersionUID = 1L;
    public static final long NEW_FILE_ID = -1L;
    private final @Nullable NoContribuable taxPayerNumber;
    private final int year;
    private final long taxFileId;
    private final @Nullable String codeDI;
    private final @Nullable String swissID;
    private final @Nullable IdentificationLevel identificationLevel;
    private final @NonNull Map<PrefillableField, String> prefillTextValueMap;
    private final boolean isCodeDILight;
    private final boolean isFiduciaire;
    private final @Nullable String fiduciaireUserId;
    private final @Nullable String fiduciaireOrganisationId;
    private final @Nullable String mobilePhone;
    private final @Nullable String fullName;
    private final @Nullable String levelOfTrust;
    private final @Nullable String swissIdSub;

    public JuAuthenticationData(@Nullable NoContribuable taxPayerNumber, int year, long taxFileId, @Nullable String codeDI, @Nullable String swissID, @Nullable IdentificationLevel identificationLevel, @NonNull Map<PrefillableField, @NonNull String> prefillTextValueMap, boolean isCodeDILight, boolean isFiduciaire, @Nullable String fiduciaireUserId, @Nullable String fiduciaireOrganisationId, @Nullable String mobilePhone, @Nullable String fullName, @Nullable String levelOfTrust, @Nullable String swissIdSub) {
        this.taxPayerNumber = taxPayerNumber;
        this.year = year;
        this.taxFileId = taxFileId;
        this.codeDI = codeDI;
        this.swissID = swissID;
        this.identificationLevel = identificationLevel;
        this.prefillTextValueMap = Collections.unmodifiableMap(Objects.requireNonNull(prefillTextValueMap, "Pre-fill map cannot be null."));
        this.isCodeDILight = isCodeDILight;
        this.isFiduciaire = isFiduciaire;
        this.fiduciaireUserId = fiduciaireUserId;
        this.fiduciaireOrganisationId = fiduciaireOrganisationId;
        this.mobilePhone = mobilePhone;
        this.fullName = fullName;
        this.levelOfTrust = levelOfTrust;
        this.swissIdSub = swissIdSub;
    }

    public @NonNull JuAuthenticationData withTaxFileId(long taxFileIdInput) {
        return new JuAuthenticationData(this.taxPayerNumber, this.year, taxFileIdInput, this.codeDI, this.swissID, this.identificationLevel, this.prefillTextValueMap, this.isCodeDILight, this.isFiduciaire, this.fiduciaireUserId, this.fiduciaireOrganisationId, this.mobilePhone, this.fullName, this.levelOfTrust, this.swissIdSub);
    }

    public @NonNull JuAuthenticationData withIsCodeDILight(Boolean isCodeDILightInput) {
        return new JuAuthenticationData(this.taxPayerNumber, this.year, this.taxFileId, this.codeDI, this.swissID, this.identificationLevel, this.prefillTextValueMap, isCodeDILightInput, this.isFiduciaire, this.fiduciaireUserId, this.fiduciaireOrganisationId, this.mobilePhone, this.fullName, this.levelOfTrust, this.swissIdSub);
    }

    public boolean isSameAuth(@Nullable JuAuthenticationData authData) {
        return authData != null && Objects.equals(this.getTaxPayerNumber(), authData.getTaxPayerNumber()) && Objects.equals(this.getYear(), authData.getYear()) && Objects.equals(authData.getTaxFileId(), this.getTaxFileId()) && Objects.equals(this.getSwissID(), authData.getSwissID()) && Objects.equals((Object)this.getIdentificationLevel(), (Object)authData.getIdentificationLevel()) && Objects.equals(this.getCodeDI(), authData.getCodeDI()) && Objects.equals(this.isCodeDILight(), authData.isCodeDILight()) && Objects.equals(this.isFiduciaire(), authData.isFiduciaire()) && Objects.equals(this.getFiduciaireUserId(), authData.getFiduciaireUserId()) && Objects.equals(this.getFiduciaireOrganisationId(), authData.getFiduciaireOrganisationId()) && Objects.equals(this.getMobilePhone(), authData.getMobilePhone()) && Objects.equals(this.getFullName(), authData.getFullName()) && Objects.equals(this.getLevelOfTrust(), authData.getLevelOfTrust()) && Objects.equals(this.getSwissIdSub(), authData.getSwissIdSub());
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("taxPayerNumber", (Object)this.getTaxPayerNumber()).append("year", this.getYear()).append("swissID", (Object)this.getSwissID()).append("identificationLevel", (Object)this.getIdentificationLevel()).append("taxFileId", this.getTaxFileId()).append("codeDI", (Object)this.getCodeDI()).append("prefill", this.getPrefillTextValueMap().entrySet()).append("isCodeDILight", this.isCodeDILight()).append("isFiduciaire", this.isFiduciaire()).append("fiduciaireUserId", (Object)this.getFiduciaireUserId()).append("fiduciaireOrganisationId", (Object)this.getFiduciaireOrganisationId()).append("mobilePhone", (Object)this.getMobilePhone()).append("fullName", (Object)this.getFullName()).append("levelOfTrust", (Object)this.getLevelOfTrust()).append("swissIdSub", (Object)this.getSwissIdSub()).build();
    }

    public @Nullable NoContribuable getTaxPayerNumber() {
        return this.taxPayerNumber;
    }

    public int getYear() {
        return this.year;
    }

    public long getTaxFileId() {
        return this.taxFileId;
    }

    public @Nullable String getCodeDI() {
        return this.codeDI;
    }

    public @Nullable String getSwissID() {
        return this.swissID;
    }

    public @Nullable IdentificationLevel getIdentificationLevel() {
        return this.identificationLevel;
    }

    public @NonNull Map<PrefillableField, String> getPrefillTextValueMap() {
        return this.prefillTextValueMap;
    }

    public boolean isCodeDILight() {
        return this.isCodeDILight;
    }

    public boolean isFiduciaire() {
        return this.isFiduciaire;
    }

    public @Nullable String getFiduciaireUserId() {
        return this.fiduciaireUserId;
    }

    public @Nullable String getFiduciaireOrganisationId() {
        return this.fiduciaireOrganisationId;
    }

    public @Nullable String getMobilePhone() {
        return this.mobilePhone;
    }

    public @Nullable String getFullName() {
        return this.fullName;
    }

    public @Nullable String getLevelOfTrust() {
        return this.levelOfTrust;
    }

    public @Nullable String getSwissIdSub() {
        return this.swissIdSub;
    }
}

