/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto;

import ch.dvbern.tax.common.integration.DvbTaxIdentification;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JuIdentification
implements DvbTaxIdentification {
    private final NoContribuable taxPayerNumber;
    private final long taxFileId;
    private final int year;
    private final String codeDI;
    private final String swissID;
    private final boolean isCodeDILight;
    private final String swissIdSub;

    public JuIdentification(@NonNull NoContribuable taxPayerNumber, long taxFileId, int year, @Nullable String codeDI, @Nullable String swissID, boolean isCodeDILight, @Nullable String swissIdSub) {
        if (taxPayerNumber == null) {
            throw new NullPointerException("Tax payer number cannot be null.");
        }
        this.taxPayerNumber = taxPayerNumber;
        this.taxFileId = taxFileId;
        this.year = year;
        this.codeDI = codeDI;
        this.swissID = swissID;
        this.isCodeDILight = isCodeDILight;
        this.swissIdSub = swissIdSub;
    }

    public @NonNull NoContribuable getTaxPayerNumber() {
        return this.taxPayerNumber;
    }

    public long getTaxFileId() {
        return this.taxFileId;
    }

    public boolean isDemoMode() {
        return this.taxPayerNumber.isDummy();
    }

    public int getSteuerjahr() {
        return this.year;
    }

    public @Nullable String getCodeDI() {
        return this.codeDI;
    }

    public @Nullable String getSwissID() {
        return this.swissID;
    }

    public boolean getIsCodeDILight() {
        return this.isCodeDILight;
    }

    public @Nullable String getSwissIdSub() {
        return this.swissIdSub;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

