/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NoContribuable
implements Serializable {
    private static final long serialVersionUID = 4030147253266161305L;
    public static final String VALIDATION_PATTERN = "(?:200|201|202)\\.\\d{3}\\.\\d{3}\\.\\d{2}";
    public static final String VALIDATION_PATTERN_DOTS_OPTIONAL = "^((?:200|201|202)\\.?\\d{3}\\.?\\d{3}\\.?\\d{2})?$";
    private static final Pattern PTN = Pattern.compile("(?:200|201|202)\\.\\d{3}\\.\\d{3}\\.\\d{2}");
    private final boolean dummy;
    private final String value;
    private final String normalized;

    private NoContribuable(String value, String normalized, boolean dummy) {
        assert (value != null && PTN.matcher(value).matches());
        this.value = value;
        this.dummy = dummy;
        this.normalized = normalized;
    }

    public static @NonNull NoContribuable parse(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("Text to parse cannot be null.");
        }
        String stringOnlyDigits = NoContribuable.removeAllNonDigits(text);
        boolean dummy = false;
        if (stringOnlyDigits.equals("00000000000")) {
            dummy = true;
        } else if (stringOnlyDigits.equals("20020020000")) {
            throw new IllegalArgumentException("Forbidden number: " + text);
        }
        if (!dummy) {
            if (!NoContribuable.isFormatValid(stringOnlyDigits)) {
                throw new IllegalArgumentException("Invalid format: " + text);
            }
            if (!NoContribuable.isNoValid(stringOnlyDigits)) {
                throw new IllegalArgumentException("Not a valid tax payer number: " + text);
            }
            if (!NoContribuable.isModuloValid(stringOnlyDigits)) {
                throw new IllegalArgumentException("Wrong check digit: " + text);
            }
        }
        String formattedNumber = NoContribuable.addPatterns(stringOnlyDigits);
        return new NoContribuable(formattedNumber, stringOnlyDigits, dummy);
    }

    public boolean isDummy() {
        return this.dummy;
    }

    private static String removeAllNonDigits(String sNoContr) {
        int stringLength = sNoContr.length();
        char[] characters = sNoContr.toCharArray();
        StringBuilder pureDigits = new StringBuilder();
        for (int i = 0; i < stringLength; ++i) {
            char character = characters[i];
            if (!Character.isDigit(character)) continue;
            pureDigits.append(character);
        }
        return pureDigits.toString();
    }

    private static boolean isFormatValid(String sNoContr) {
        try {
            new Long(sNoContr);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return sNoContr.length() == 11;
    }

    private static boolean isNoValid(String sNoContr) {
        return sNoContr.startsWith("200") || sNoContr.startsWith("201") || sNoContr.startsWith("202");
    }

    private static boolean isModuloValid(String sNoContr) {
        int pruefziffer = Integer.valueOf(sNoContr.substring(sNoContr.length() - 1));
        String noContrOhnePruefziffer = sNoContr.substring(0, sNoContr.length() - 1);
        int[] calcTable = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};
        int length = noContrOhnePruefziffer.length();
        int result = calcTable[noContrOhnePruefziffer.charAt(0) - 48];
        for (int i = 1; i < length; ++i) {
            result = calcTable[(result + noContrOhnePruefziffer.charAt(i) - 48) % 10];
        }
        int calcPruefziffer = result == 0 ? 0 : 10 - result;
        return pruefziffer == calcPruefziffer;
    }

    private static String addPatterns(String sNoContr) {
        String newNoContr = sNoContr.substring(0, 3) + "." + sNoContr.substring(3, 6) + "." + sNoContr.substring(6, 9) + "." + sNoContr.substring(9);
        return newNoContr;
    }

    public String toExternalForm() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public String getNormalized() {
        return this.normalized;
    }

    public boolean equals(Object obj) {
        return obj instanceof NoContribuable && obj.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

