/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto;

import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DateConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TelConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import ch.dvbern.tax.ju.transfer.dto.convert.AhvConverter;
import ch.dvbern.tax.ju.transfer.dto.convert.JuMailConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PrefillableField
extends Enum<PrefillableField> {
    public static final /* enum */ PrefillableField AVS_NUMBER = new PrefillableField("AVSNumber", "Stammdaten.Monsieur.NoAvs", Transformers.AHV_TRANSFORMER);
    public static final /* enum */ PrefillableField BIRTH_DATE = new PrefillableField("BirthDate", "Stammdaten.Monsieur.DateNaissance", Transformers.DATE_TRANSFORMER);
    public static final /* enum */ PrefillableField FIRST_NAME = new PrefillableField("Firstname", "Stammdaten.Monsieur.Prenom", Transformers.STRING_TRANSFORMER);
    public static final /* enum */ PrefillableField LAST_NAME = new PrefillableField("Lastname", "Stammdaten.Monsieur.Nom", Transformers.STRING_TRANSFORMER);
    public static final /* enum */ PrefillableField E_MAIL = new PrefillableField("Email", "Stammdaten.Declaration.AdresseEmail", Transformers.MAIL_TRANSFORMER);
    public static final /* enum */ PrefillableField PHONE = new PrefillableField("Phone", "Stammdaten.Declaration.TelPrive", Transformers.TEL_TRANSFORMER);
    public static final /* enum */ PrefillableField ZIP = new PrefillableField("Zip", "Stammdaten.Declaration.Npa", Transformers.STRING_TRANSFORMER);
    public static final /* enum */ PrefillableField CITY = new PrefillableField("City", "Stammdaten.Declaration.Localite", Transformers.STRING_TRANSFORMER);
    public static final /* enum */ PrefillableField ADDRESS = new PrefillableField("Address", "Stammdaten.Declaration.RueNo", Transformers.STRING_TRANSFORMER);
    private static final Map<String, PrefillableField> FIELD_NAMES_MAP;
    private final @NonNull String fieldName;
    private final @NonNull String dmk;
    private final @NonNull BiFunction<String, Item, Object> transformer;
    private static final /* synthetic */ PrefillableField[] $VALUES;

    public static PrefillableField[] values() {
        return (PrefillableField[])$VALUES.clone();
    }

    public static PrefillableField valueOf(String name) {
        return Enum.valueOf(PrefillableField.class, name);
    }

    private PrefillableField(String fieldName, String dmk, BiFunction<String, Item, Object> transformer) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.dmk = Objects.requireNonNull(dmk);
        this.transformer = Objects.requireNonNull(transformer);
    }

    public @NonNull String getFieldName() {
        return this.fieldName;
    }

    public @NonNull String getDmk() {
        return this.dmk;
    }

    public @NonNull BiFunction<String, Item, Object> getTransformer() {
        return this.transformer;
    }

    public static @Nullable PrefillableField forFieldName(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("Field name cannot be null.");
        }
        return FIELD_NAMES_MAP.get(fieldName);
    }

    private static /* synthetic */ PrefillableField[] $values() {
        return new PrefillableField[]{AVS_NUMBER, BIRTH_DATE, FIRST_NAME, LAST_NAME, E_MAIL, PHONE, ZIP, CITY, ADDRESS};
    }

    static {
        $VALUES = PrefillableField.$values();
        PrefillableField[] values = PrefillableField.values();
        FIELD_NAMES_MAP = new HashMap<String, PrefillableField>(values.length);
        for (PrefillableField prefillableField : values) {
            boolean duplicate;
            boolean bl = duplicate = FIELD_NAMES_MAP.put(prefillableField.fieldName, prefillableField) != null;
            assert (!duplicate);
        }
    }

    static class Transformers {
        static final BiFunction<String, Item, Object> STRING_TRANSFORMER = (textValue, item) -> {
            try {
                return ((TextConverter)item.getRendererAndValidator()).parseString(textValue);
            }
            catch (AbstractConverter.ConvertException e) {
                throw new IllegalStateException("Error converting data: " + item.getValueKey() + " = " + textValue);
            }
        };
        static final BiFunction<String, Item, Object> DATE_TRANSFORMER = (textValue, item) -> {
            try {
                return ((DateConverter)item.getRendererAndValidator()).parseString(textValue);
            }
            catch (AbstractConverter.ConvertException e) {
                throw new IllegalStateException("Error converting data: " + item.getValueKey() + " = " + textValue);
            }
        };
        static final BiFunction<String, Item, Object> AHV_TRANSFORMER = (textValue, item) -> {
            try {
                return ((AhvConverter)item.getRendererAndValidator()).parseString((String)textValue);
            }
            catch (AbstractConverter.ConvertException e) {
                throw new IllegalStateException("Error converting data: " + item.getValueKey() + " = " + textValue);
            }
        };
        static final BiFunction<String, Item, Object> MAIL_TRANSFORMER = (textValue, item) -> {
            try {
                return ((JuMailConverter)item.getRendererAndValidator()).parseString((String)textValue);
            }
            catch (AbstractConverter.ConvertException e) {
                throw new IllegalStateException("Error converting data: " + item.getValueKey() + " = " + textValue);
            }
        };
        static final BiFunction<String, Item, Object> TEL_TRANSFORMER = (textValue, item) -> {
            try {
                return ((TelConverter)item.getRendererAndValidator()).parseString(textValue);
            }
            catch (AbstractConverter.ConvertException e) {
                throw new IllegalStateException("Error converting data: " + item.getValueKey() + " = " + textValue);
            }
        };

        Transformers() {
        }
    }
}

