/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import org.apache.commons.lang3.CharUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AhvConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3618977871490462256L;

    public AhvConverter() {
        super(String.class);
    }

    public @Nullable String getObject(@Nullable String ahvString, @Nullable OptionItemsDTO optionItems, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        return this.parseString(ahvString);
    }

    public @Nullable String parseString(@Nullable String ahvString) throws AbstractConverter.ConvertException {
        if (ahvString == null || ahvString.length() <= 0) {
            return null;
        }
        int[] digits = this.getDigits(ahvString.replaceAll("\\s+", ""));
        if (digits == null || !this.checkEAN13(digits)) {
            throw new AbstractConverter.ConvertException("error.format.ahv");
        }
        return this.render(digits);
    }

    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        String str = o.toString();
        int[] digits = this.getDigits(str);
        if (digits != null) {
            return this.render(digits);
        }
        return str;
    }

    private @Nullable String render(int[] digits) {
        assert (digits != null);
        Object[] args = new Integer[digits.length];
        for (int i = 0; i < digits.length; ++i) {
            args[i] = digits[i];
        }
        return String.format("%d%d%d.%d%d%d%d.%d%d%d%d.%d%d", args);
    }

    public @NonNull String getUserInputRegExpPattern() {
        return "[0-9]{1,3}(\\.?|\\s)[0-9]{0,4}(\\.?|\\s)[0-9]{0,4}(\\.?|\\s)[0-9]{0,2}";
    }

    private boolean checkEAN13(int[] digits) {
        assert (digits != null);
        if (digits.length != 13) {
            return false;
        }
        int checkDigit = 0;
        for (int i = digits.length - 2; i >= 0; --i) {
            if (i % 2 == 0) {
                checkDigit += digits[i];
                continue;
            }
            checkDigit += digits[i] * 3;
        }
        int modulus = checkDigit % 10;
        checkDigit = modulus == 0 ? 0 : 10 - modulus;
        return checkDigit == digits[digits.length - 1];
    }

    private @Nullable int[] getDigits(String sAvs) {
        int[] digits = new int[13];
        int digitsIdx = 0;
        for (int strIdx = 0; strIdx < sAvs.length(); ++strIdx) {
            char c = sAvs.charAt(strIdx);
            if (CharUtils.isAsciiNumeric((char)c)) {
                if (digitsIdx >= digits.length) {
                    return null;
                }
                digits[digitsIdx++] = Character.digit(c, 10);
                continue;
            }
            if (c == '.') continue;
            return null;
        }
        if (digitsIdx < digits.length) {
            return null;
        }
        return digits;
    }
}

