/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JuTextConverter
extends TextConverter {
    private static final long serialVersionUID = 1983157152849399341L;
    private final boolean substituteLatinExtended;
    private static final List<String> CHARS_TO_BE_SUBSTITUTED = Collections.unmodifiableList(Arrays.asList("\u00e3", "\u1ebd", "\u0129", "\u00f1", "\u00f5", "\u0169", "\u00c3", "\u1ebc", "\u0128", "\u00d1", "\u00d5", "\u0168"));
    private static final List<String> SUBSTITUTING_CHARS = Collections.unmodifiableList(Arrays.asList("a", "e", "i", "n", "o", "u", "A", "E", "I", "N", "O", "U"));

    public JuTextConverter(int maxLength) {
        super(maxLength);
        this.substituteLatinExtended = false;
    }

    public JuTextConverter(int maxLength, boolean substituteLatinExtended) {
        super(maxLength);
        this.substituteLatinExtended = substituteLatinExtended;
    }

    protected @Nullable String substitute(char currentChar) {
        int substIndex;
        String currentLetter = super.substitute(currentChar);
        if (this.substituteLatinExtended && (substIndex = CHARS_TO_BE_SUBSTITUTED.indexOf(currentLetter)) >= 0) {
            return SUBSTITUTING_CHARS.get(substIndex);
        }
        return currentLetter;
    }
}

