/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class NoIBAN
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3258413941062578742L;
    private final Pattern patternValidate = Pattern.compile("(\\d\\d)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w)");
    private final Pattern patternRender = Pattern.compile("(\\d\\d)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w\\w\\w\\w)(\\ ?)(\\w)");

    public NoIBAN() {
        super(String.class);
    }

    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.patternValidate.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.noIBAN");
        }
        if (!this.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.noIBAN");
        }
        return s;
    }

    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        Matcher m = this.patternRender.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + m.group(2) + m.group(3) + m.group(4) + m.group(5) + m.group(6) + m.group(7) + m.group(8) + m.group(9) + m.group(10) + m.group(11);
        }
        return o.toString();
    }

    public @NonNull String getUserInputRegExpPattern() {
        return "[0-9]|[0-9]{2}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,4}(\\ ?)[0-9a-zA-Z]{0,1}";
    }

    private boolean isValid(String noIbanComplet) {
        String noIbanAvecPays = "CH" + noIbanComplet.replaceAll(" ", "");
        String noIbanPretPourControle = noIbanAvecPays.substring(4, 21) + noIbanAvecPays.substring(0, 4);
        String sNoIbanNumerique = this.transformeToNumber(noIbanPretPourControle);
        Object noToDivide = sNoIbanNumerique.substring(0, 9);
        sNoIbanNumerique = sNoIbanNumerique.substring(9, sNoIbanNumerique.length());
        while (sNoIbanNumerique.length() >= 0) {
            long reste = Long.valueOf((String)noToDivide) % 97L;
            if (reste / 10L > 0L) {
                if (sNoIbanNumerique.length() >= 7) {
                    noToDivide = reste + sNoIbanNumerique.substring(0, 7);
                    sNoIbanNumerique = sNoIbanNumerique.substring(7, sNoIbanNumerique.length());
                    continue;
                }
                noToDivide = reste + sNoIbanNumerique.substring(0, sNoIbanNumerique.length());
                return Long.valueOf((String)noToDivide) % 97L == 1L;
            }
            if (sNoIbanNumerique.length() >= 8) {
                noToDivide = reste + sNoIbanNumerique.substring(0, 8);
                sNoIbanNumerique = sNoIbanNumerique.substring(8, sNoIbanNumerique.length());
                continue;
            }
            noToDivide = reste + sNoIbanNumerique.substring(0, sNoIbanNumerique.length());
            return Long.valueOf((String)noToDivide) % 97L == 1L;
        }
        return false;
    }

    private @NonNull String transformeToNumber(String noIbanAlphanumerique) {
        String noIbanAlphanumeriqueMaj = noIbanAlphanumerique.toUpperCase();
        StringBuilder noIbanNumerique = new StringBuilder();
        for (int i = 0; i < noIbanAlphanumeriqueMaj.length(); ++i) {
            char caractere = noIbanAlphanumeriqueMaj.charAt(i);
            if (!Character.isDigit(caractere)) {
                String temp = Integer.toString(caractere - 55);
                noIbanNumerique.append(temp);
                continue;
            }
            noIbanNumerique.append(caractere);
        }
        return noIbanNumerique.toString();
    }
}

