/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TruncateStringConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 1L;
    private int truncatePosition;

    public TruncateStringConverter(int truncatePosition) {
        super(String.class);
        this.truncatePosition = truncatePosition;
    }

    @Nullable
    public String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\s", " ");
        if (s.length() <= this.truncatePosition) {
            return s;
        }
        return s.substring(0, this.truncatePosition);
    }

    @Nullable
    public String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @Nonnull AbstractConverter.ConverterContext ctx) {
        return (String)o;
    }

    @Nonnull
    public String getUserInputRegExpPattern() {
        return "^.{1," + this.truncatePosition + "}$";
    }
}

