/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.transfer.esteuerauszug;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.FileData;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TSImportParams {
    public final int steuerjahr;
    public final @NonNull Map<String, LogicModelItem> logicModel;
    public final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel;
    public final @NonNull Function<@NonNull DMK, @Nullable FileData> fileDataLoader;
    public final @NonNull Consumer<Map<String, ModelItemDTO>> updater;

    public TSImportParams(int steuerjahr, @NonNull Map<String, LogicModelItem> logicModel, @NonNull Map<String, ModelItemDTO> dataModel, @NonNull Consumer<@NonNull Map<String, ModelItemDTO>> updater, @NonNull Function<@NonNull DMK, @Nullable FileData> fileDataLoader) {
        this.steuerjahr = steuerjahr;
        this.logicModel = Collections.unmodifiableMap(Objects.requireNonNull(logicModel));
        this.dataModel = new LogicModelItem.ProtectedMap(Collections.unmodifiableMap(Objects.requireNonNull(dataModel)), false);
        this.updater = Objects.requireNonNull(updater);
        this.fileDataLoader = Objects.requireNonNull(fileDataLoader);
    }

    public static @NonNull TSImportParams from(@NonNull DvbTaxSession session, @NonNull Consumer<Map<String, ModelItemDTO>> updater) {
        Objects.requireNonNull(session);
        Objects.requireNonNull(updater);
        return new TSImportParams(Objects.requireNonNull(session.getTmoIdentification()).getSteuerjahr(), session.getLogicModel(), Objects.requireNonNull(session.getDataModel()), updater, arg_0 -> ((DvbTaxSession)session).getFileData(arg_0));
    }

    public <T> @Nullable T modelValue(@NonNull LMK lmk, @NonNull DMK row) {
        Objects.requireNonNull(lmk);
        Objects.requireNonNull(row);
        Objects.requireNonNull(this.getLogicModel().get(lmk.toExternalForm()), "LMK does not exist in logicmodel: " + String.valueOf(lmk));
        ModelItemDTO modelItemDTO = this.getDataModel().get((Object)row.merge(lmk).toExternalForm());
        return (T)modelItemDTO.getValue();
    }

    public int getSteuerjahr() {
        return this.steuerjahr;
    }

    public @NonNull Map<String, LogicModelItem> getLogicModel() {
        return this.logicModel;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap getDataModel() {
        return this.dataModel;
    }

    public @NonNull Consumer<Map<String, ModelItemDTO>> getUpdater() {
        return this.updater;
    }

    public @NonNull Function<DMK, FileData> getFileDataLoader() {
        return this.fileDataLoader;
    }
}

