/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.presentation.common.util.TaxFileUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.engine.expertdisplay.JuBarcodeGenerator;
import ch.dvbern.tax.ju.engine.justificatifs.DocumentStore;
import ch.dvbern.tax.ju.engine.justificatifs.DocumentStoreIndex;
import ch.dvbern.tax.ju.engine.justificatifs.EReleveDocument;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import ch.dvbern.tax.ju.upload.UploadDocsPrinter;
import ch.dvbern.tax.ju.upload.UploadInfo;
import ch.dvbern.tax.ju.utils.ProgressMonitor;
import ch.dvbern.tax.ju.utils.Task;
import ch.dvbern.tax.ju.utils.TaskFailedException;
import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveGenerationTask
implements Task {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveGenerationTask.class);
    private final DvbTaxSession session;
    private final OutputStream output;
    private final UploadInfo uploadInfo;
    private final AbstractConverter.ConverterContext ctx;
    private final ImageSource imgSrc;
    private final DocumentStore documentStore;
    private final DocumentStoreIndex index;
    private final List<EReleveDocument> erefDocuments;
    private final Path declarationPath;
    private static final boolean DEBUG_ONLINE = ApplicationConfig.getInstance().getBoolean("debugEnabledOnline", false);
    private Instant timestamp;
    private volatile String digest = null;

    public ArchiveGenerationTask(@NonNull DvbTaxSession session, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractConverter.ConverterContext ctx, @NonNull ImageSource imgSrc, @NonNull OutputStream output, @NonNull UploadInfo uploadInfo, @Nullable DocumentStore documentStore, DocumentStoreIndex index, @NonNull List<EReleveDocument> erefDocuments, @Nullable Path declarationPath) {
        this.session = Objects.requireNonNull(session, "Current user session cannot be null.");
        this.ctx = Objects.requireNonNull(ctx, "Converter context cannot be null.");
        this.imgSrc = Objects.requireNonNull(imgSrc, "Image source cannot be null.");
        this.output = Objects.requireNonNull(output, "Output stream cannot be null.");
        this.uploadInfo = Objects.requireNonNull(uploadInfo, "Upload info cannot be null.");
        this.documentStore = documentStore;
        this.index = index;
        this.erefDocuments = erefDocuments;
        this.declarationPath = declarationPath;
        if (index != null && index.hasMissingDescriptions()) {
            throw new IllegalArgumentException("Document store index is not complete.");
        }
    }

    @Override
    public void run(ProgressMonitor monitor) throws TaskFailedException, InterruptedException {
        try {
            this.runInternal(monitor);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskFailedException("Failed to generate archive file.", e);
        }
    }

    private void runInternal(ProgressMonitor monitor) throws IOException, NoSuchAlgorithmException, InterruptedException, LocalizationHelper.LocalizationHelperException, FormRendererException, DocumentException {
        this.timestamp = Instant.now();
        byte[] barcode = this.generateBarcode(monitor);
        this.checkCancellation(monitor);
        MessageDigest msgDigest = MessageDigest.getInstance("SHA-256");
        String numeroContribuable = this.uploadInfo.getTaxPayerNumber();
        DigestOutputStream digestStream = new DigestOutputStream(this.output, msgDigest);
        ZipOutputStream zipStream = new ZipOutputStream(digestStream);
        zipStream.putNextEntry(new ZipEntry(numeroContribuable + ".pdf"));
        if (this.declarationPath == null || Files.notExists(this.declarationPath, new LinkOption[0])) {
            this.generatePDF(this.session, barcode, zipStream, monitor.newChild(40));
        } else {
            zipStream.write(Files.readAllBytes(this.declarationPath));
        }
        if (DEBUG_ONLINE) {
            this.saveSubmittedFilesLocally(monitor, barcode, numeroContribuable);
        }
        this.checkCancellation(monitor);
        this.generateJustificatifsSummary(this.session, zipStream, monitor.newChild(10));
        this.checkCancellation(monitor);
        if (this.documentStore != null && this.index != null && this.index.getResolvedCategories().isUserDocumentsAllowed() && !this.index.getAllUserDocuments().isEmpty()) {
            zipStream.putNextEntry(new ZipEntry("justificatifs.pdf"));
            this.generateJustificatifs(zipStream, monitor);
        }
        zipStream.putNextEntry(new ZipEntry(numeroContribuable + ".tax"));
        this.storeTaxFile(zipStream, monitor.newChild(10));
        zipStream.putNextEntry(new ZipEntry(numeroContribuable + ".xml"));
        zipStream.write(barcode);
        monitor.worked(7);
        zipStream.putNextEntry(new ZipEntry("info.json"));
        this.generateInfo(zipStream);
        monitor.worked(3);
        zipStream.finish();
        zipStream.flush();
        int digestLength = msgDigest.getDigestLength();
        String fmt = digestLength > 0 ? "%0" + digestLength * 2 + "x" : "%x";
        this.digest = String.format(fmt, new BigInteger(1, msgDigest.digest()));
        this.checkCancellation(monitor);
    }

    private void saveSubmittedFilesLocally(ProgressMonitor monitor, byte[] barcode, String numeroContribuable) throws IOException, InterruptedException, FormRendererException, DocumentException {
        long steuerJahr = ApplicationConfig.getInstance().getJahr();
        String path = System.getProperty("user.home") + File.separator + "JuraTax" + steuerJahr + File.separator + "Archive";
        String fileName = "televersementArchive.zip";
        new File(path).mkdirs();
        FileOutputStream fos = new FileOutputStream(path + File.separator + fileName);
        ZipOutputStream storeZip = new ZipOutputStream(fos);
        storeZip.putNextEntry(new ZipEntry(numeroContribuable + ".pdf"));
        this.generatePDF(this.session, barcode, storeZip, monitor.newChild(40));
        this.generateJustificatifsSummary(this.session, storeZip, monitor.newChild(10));
        if (this.documentStore != null && this.index != null && this.index.getResolvedCategories().isUserDocumentsAllowed() && !this.index.getAllUserDocuments().isEmpty()) {
            storeZip.putNextEntry(new ZipEntry("justificatifs.pdf"));
            this.generateJustificatifs(storeZip, monitor);
        }
        storeZip.finish();
        storeZip.flush();
    }

    private void generatePDF(DvbTaxSession session, byte[] barcode, OutputStream output, ProgressMonitor monitor) throws InterruptedException, LocalizationHelper.LocalizationHelperException, FormRendererException {
        FormRendererConfiguration configuration = JuUtil.newPrintConfiguration().withTimestamp(Long.valueOf(this.timestamp.toEpochMilli())).withProperty("barcode", (Object)ZipHelper.zip((byte[])barcode, (String)(this.uploadInfo.getTaxPayerNumber() + ".xml")));
        List formKeys = PrintUtil.getPrintAllKeys((DvbTaxSession)session);
        String codeDI = this.uploadInfo.getCodeDI();
        if (codeDI != null) {
            formKeys.add(new FormKey("Synthese", Mode.EXPERT));
            JuUtil.prepareSummaryPagePrint(configuration, codeDI, this.timestamp);
        }
        this.print(formKeys, configuration, output, monitor);
    }

    private void generateJustificatifsSummary(DvbTaxSession session, ZipOutputStream output, ProgressMonitor monitor) throws InterruptedException, LocalizationHelper.LocalizationHelperException, FormRendererException, IOException {
        if (JuUtil.hasJustificatifs(session)) {
            output.putNextEntry(new ZipEntry("PJListRequest.pdf"));
            FormRendererConfiguration configuration = JuUtil.newPrintConfiguration().withTimestamp(Long.valueOf(this.timestamp.toEpochMilli())).withProperty("justificatifs.adresse", (Object)this.ctx.getLocalizationHelper().translate("label.justificatifs.impression.adresse", new Object[0]));
            this.print(Collections.singletonList(new FormKey("Justificatifs", Mode.EXPERT)), configuration, output, monitor);
        }
    }

    private void print(List<FormKey> formKeys, FormRendererConfiguration configuration, OutputStream output, ProgressMonitor monitor) throws LocalizationHelper.LocalizationHelperException, InterruptedException, FormRendererException {
        monitor.beginTask(this.ctx.getLocalizationHelper().translate("label.dialog.upload.archivegeneration.pdf", new Object[0]), formKeys.size());
        ProgressListener progressListener = form -> monitor.worked(1);
        PrintRequest printRequest = new PrintRequest(this.ctx, this.imgSrc).withConfiguration(configuration).withProgressListener(progressListener).withFormKeys(formKeys);
        PrintUtil.print((DvbTaxSession)this.session, (PrintRequest)printRequest, (OutputStream)output, (boolean)false);
        monitor.done();
    }

    private byte[] generateBarcode(ProgressMonitor monitor) throws LocalizationHelper.LocalizationHelperException {
        monitor.beginTask(this.ctx.getLocalizationHelper().translate("label.dialog.upload.archivegeneration.xml", new Object[0]), -1);
        JuBarcodeGenerator barcodeGenerator = new JuBarcodeGenerator(false, this.timestamp, this.uploadInfo.getCodeDI() != null ? UploadConfiguration.UploadType.WITH_CODE_DI : UploadConfiguration.UploadType.WITH_SWISSID, this.uploadInfo.getSysInfo());
        byte[] barcode = this.session.generateBarcode((Barcode2DGenerator)barcodeGenerator).getData();
        monitor.done();
        return barcode;
    }

    private void storeTaxFile(OutputStream output, ProgressMonitor monitor) throws IOException, LocalizationHelper.LocalizationHelperException {
        monitor.beginTask(this.ctx.getLocalizationHelper().translate("label.dialog.upload.archivegeneration.tax", new Object[0]), -1);
        HashMap dataModel = new HashMap(this.session.getDataModel());
        try {
            TaxFileUtil.write((OutputStream)output, dataModel, (String)"");
        }
        catch (ApplicationException e) {
            throw new IOException("Failed to dump tax file", e);
        }
        monitor.done();
    }

    private void generateJustificatifs(OutputStream output, ProgressMonitor monitor) throws DocumentException, IOException {
        assert (output != null && monitor != null && this.documentStore != null && this.index != null && !this.index.getAllUserDocuments().isEmpty());
        UploadDocsPrinter docsPrinter = new UploadDocsPrinter(this.session.getDataModel(), this.documentStore, this.index, this.erefDocuments);
        docsPrinter.print(output, monitor);
    }

    private void generateInfo(OutputStream output) {
        this.uploadInfo.saveInfoFile(output);
    }

    public String getDigest() {
        return this.digest;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    private void checkCancellation(ProgressMonitor monitor) throws InterruptedException {
        if (monitor != null && monitor.isCancelled()) {
            throw new InterruptedException("Monitored interruption.");
        }
        if (Thread.interrupted()) {
            throw new InterruptedException("Current thread has been interrupted.");
        }
    }
}

