/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.presentation.common.print.ProgressListener;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.engine.expertdisplay.JuBarcodeGenerator;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import ch.dvbern.tax.ju.upload.UploadInfo;
import ch.dvbern.tax.ju.utils.ProgressMonitor;
import ch.dvbern.tax.ju.utils.Task;
import ch.dvbern.tax.ju.utils.TaskFailedException;
import com.lowagie.text.DocumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeclarationGenerationTask
implements Task {
    private static final Logger LOG = LoggerFactory.getLogger(DeclarationGenerationTask.class);
    private final DvbTaxSession session;
    private final OutputStream output;
    private final UploadInfo uploadInfo;
    private final AbstractConverter.ConverterContext ctx;
    private final ImageSource imgSrc;
    private Instant timestamp;

    public DeclarationGenerationTask(@NonNull DvbTaxSession session, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractConverter.ConverterContext ctx, @NonNull ImageSource imgSrc, @NonNull OutputStream output, @NonNull UploadInfo uploadInfo) {
        this.session = Objects.requireNonNull(session, "Current user session cannot be null.");
        this.ctx = Objects.requireNonNull(ctx, "Converter context cannot be null.");
        this.imgSrc = Objects.requireNonNull(imgSrc, "Image source cannot be null.");
        this.output = Objects.requireNonNull(output, "Output stream cannot be null.");
        this.uploadInfo = Objects.requireNonNull(uploadInfo, "Upload info cannot be null.");
    }

    @Override
    public void run(ProgressMonitor monitor) throws TaskFailedException, InterruptedException {
        try {
            this.runInternal(monitor);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskFailedException("Failed to generate archive file.", e);
        }
    }

    private void runInternal(ProgressMonitor monitor) throws IOException, InterruptedException, LocalizationHelper.LocalizationHelperException, FormRendererException, DocumentException {
        this.timestamp = Instant.now();
        byte[] barcode = this.generateBarcode(monitor);
        this.checkCancellation(monitor);
        this.generatePDF(this.session, barcode, this.output, monitor.newChild(40));
        this.checkCancellation(monitor);
        this.output.flush();
        this.checkCancellation(monitor);
    }

    private void generatePDF(DvbTaxSession session, byte[] barcode, OutputStream output, ProgressMonitor monitor) throws InterruptedException, LocalizationHelper.LocalizationHelperException, FormRendererException {
        FormRendererConfiguration configuration = JuUtil.newPrintConfiguration().withTimestamp(Long.valueOf(this.timestamp.toEpochMilli())).withProperty("barcode", (Object)ZipHelper.zip((byte[])barcode, (String)(this.uploadInfo.getTaxPayerNumber() + ".xml")));
        List formKeys = PrintUtil.getPrintAllKeys((DvbTaxSession)session);
        String codeDI = this.uploadInfo.getCodeDI();
        if (codeDI != null) {
            formKeys.add(new FormKey("Synthese", Mode.EXPERT));
            JuUtil.prepareSummaryPagePrint(configuration, codeDI, this.timestamp);
        }
        this.print(formKeys, configuration, output, monitor);
    }

    private void print(List<FormKey> formKeys, FormRendererConfiguration configuration, OutputStream output, ProgressMonitor monitor) throws LocalizationHelper.LocalizationHelperException, InterruptedException, FormRendererException {
        monitor.beginTask(this.ctx.getLocalizationHelper().translate("label.dialog.upload.archivegeneration.pdf", new Object[0]), formKeys.size());
        ProgressListener progressListener = form -> monitor.worked(1);
        PrintRequest printRequest = new PrintRequest(this.ctx, this.imgSrc).withConfiguration(configuration).withProgressListener(progressListener).withFormKeys(formKeys);
        PrintUtil.print((DvbTaxSession)this.session, (PrintRequest)printRequest, (OutputStream)output, (boolean)false);
        monitor.done();
    }

    private byte[] generateBarcode(ProgressMonitor monitor) throws LocalizationHelper.LocalizationHelperException {
        monitor.beginTask(this.ctx.getLocalizationHelper().translate("label.dialog.upload.archivegeneration.xml", new Object[0]), -1);
        JuBarcodeGenerator barcodeGenerator = new JuBarcodeGenerator(false, this.timestamp, this.uploadInfo.getCodeDI() != null ? UploadConfiguration.UploadType.WITH_CODE_DI : UploadConfiguration.UploadType.WITH_SWISSID, this.uploadInfo.getSysInfo());
        byte[] barcode = this.session.generateBarcode((Barcode2DGenerator)barcodeGenerator).getData();
        monitor.done();
        return barcode;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    private void checkCancellation(ProgressMonitor monitor) throws InterruptedException {
        if (monitor != null && monitor.isCancelled()) {
            throw new InterruptedException("Monitored interruption.");
        }
        if (Thread.interrupted()) {
            throw new InterruptedException("Current thread has been interrupted.");
        }
    }
}

