/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.ju.upload.UploadStatusDTO;
import ch.dvbern.tax.ju.upload.UploadValidationStatus;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvedUploadStatusDTO
implements Serializable {
    private static final long serialVersionUID = -2984630240459865373L;
    private static final Logger LOG = LoggerFactory.getLogger(ResolvedUploadStatusDTO.class);
    public final boolean validationPerformed;
    public final @Nullable UploadStatusDTO status;
    private static final Comparator<UploadStatusDTO> UPLOAD_DATE_COMPARATOR = Comparator.comparing(UploadStatusDTO::getTimestamp);

    public ResolvedUploadStatusDTO(boolean validationPerformed, @Nullable UploadStatusDTO status) {
        this.validationPerformed = validationPerformed;
        this.status = status;
    }

    public static @NonNull ResolvedUploadStatusDTO resolveUploadStatus(@NonNull Collection<UUID> request, @NonNull List<UploadStatusDTO> response, boolean validationPerformed) {
        if (request == null) {
            throw new NullPointerException("Request GUIDs cannot be null.");
        }
        if (response == null) {
            throw new NullPointerException("Response statuses cannot be null.");
        }
        UploadStatusDTO status = null;
        if (!response.isEmpty()) {
            status = Collections.max(response, UPLOAD_DATE_COMPARATOR);
            if (request.contains(status.getGuid())) {
                UploadValidationStatus validationStatus = status.getValidationStatus();
                if (validationPerformed) {
                    if (validationStatus == UploadValidationStatus.NOT_VALIDATED) {
                        LOG.warn("Status info returned by server is non-validated despite validation being performed, discard it: {}", (Object)status);
                        status = null;
                    } else if (validationStatus == UploadValidationStatus.VALIDATED_WITH_CODE_DI && status.getDeclarationCode() == null) {
                        LOG.warn("Missing declaration code in status info returned by server, discard it: {}", (Object)status);
                        status = null;
                    }
                } else if (validationStatus != UploadValidationStatus.NOT_VALIDATED) {
                    LOG.warn("Found a entry with validated status {} but the upload service said previously there was none: assume there is one.", (Object)validationStatus);
                    validationPerformed = true;
                }
            } else {
                LOG.warn("Status info returned by server has unknown GUID: {}, discard it.", (Object)status);
                status = null;
            }
        }
        return new ResolvedUploadStatusDTO(validationPerformed, status);
    }
}

