/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.ju.engine.util.PKey;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadConfiguration {
    private static final Logger LOG;
    public static final String DIGEST_ALGORITHM = "SHA-256";
    public static PKey APPLICATION_PROFILE_PKEY;
    public static PKey OS_IDENTIFIER_PKEY;
    public static PKey JVM_IDENTIFIER_PKEY;
    public static PKey UPLOAD_TYPE_PKEY;
    public static final String TAX_FNAME_EXT = ".tax";
    public static final String XML_FNAME_EXT = ".xml";
    public static final String PDF_FNAME_EXT = ".pdf";
    public static final String JUSTIFICATIFS_FNAME = "PJListRequest.pdf";
    public static final String INFO_FNAME = "info.json";
    public static final String DEFAULT_UPLOAD_DIRPATH = "televersement";
    public static final String UPLOAD_DIRNAME_CONFIG_KEY = "upload.dir";
    public static final String DEFAULT_HISTORY_FILEPATH = "history.dat";
    public static final String HISTORY_FILEPATH_CONFIG_KEY = "upload.history";
    private static final String TIMEZONE_ID = "Europe/Zurich";
    public static final ZoneId TIMEZONE;
    public static final Locale LOCALE;

    static {
        ZoneId timezone;
        LOG = LoggerFactory.getLogger(UploadConfiguration.class);
        APPLICATION_PROFILE_PKEY = PKey.parse("0000;2003-01;N");
        OS_IDENTIFIER_PKEY = PKey.parse("0000;2004-01;N");
        JVM_IDENTIFIER_PKEY = PKey.parse("0000;2005-01;N");
        UPLOAD_TYPE_PKEY = PKey.parse("0000;2000-01;N");
        try {
            timezone = ZoneId.of(TIMEZONE_ID);
        }
        catch (IllegalArgumentException e) {
            timezone = ZoneId.systemDefault();
            LOG.warn("Timezone not found: {}, fallback to default: {}", (Object)TIMEZONE_ID, (Object)timezone);
        }
        TIMEZONE = timezone;
        LOCALE = new Locale("fr", "ch");
    }

    public static enum UploadType implements Serializable
    {
        WITH_SWISSID(1, 1),
        WITH_CODE_DI(2, 2),
        PRINT(-1, 3);

        private final int validationCode;
        private final int barcodeValue;

        private UploadType(int validationCode, int barcodeValue) {
            this.validationCode = validationCode;
            this.barcodeValue = barcodeValue;
        }

        public int getValidationCode() {
            return this.validationCode;
        }

        public int getBarcodeValue() {
            return this.barcodeValue;
        }
    }
}

