/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class UploadDataSource
implements DataSource {
    private final NoContribuable numeroContribuable;
    private final int year;
    private final String digest;

    protected UploadDataSource(@NonNull NoContribuable numeroContribuable, int year, @NonNull String digest) {
        if (numeroContribuable == null) {
            throw new NullPointerException("Tax payer number cannot be null.");
        }
        this.numeroContribuable = Objects.requireNonNull(numeroContribuable, "Tax payer number cannot be null.");
        this.year = year;
        this.digest = Objects.requireNonNull(digest, "Archive digest cannot be null.");
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public String getName() {
        return "tax_archive_" + String.valueOf(this.numeroContribuable) + "_" + this.year + ".zip";
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("This data source is read-only.");
    }

    public @NonNull String getDigest() {
        return this.digest;
    }
}

