/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.engine.justificatifs.DocumentStore;
import ch.dvbern.tax.ju.engine.justificatifs.DocumentStoreIndex;
import ch.dvbern.tax.ju.engine.justificatifs.EReleveDocument;
import ch.dvbern.tax.ju.engine.justificatifs.ExtraUserDocument;
import ch.dvbern.tax.ju.engine.justificatifs.MappedUserDocument;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategories;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategory;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedDocument;
import ch.dvbern.tax.ju.upload.ArchiveGenerationTask;
import ch.dvbern.tax.ju.utils.ProgressMonitor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.ListItem;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.draw.DrawInterface;
import com.lowagie.text.pdf.draw.VerticalPositionMark;
import com.sun.istack.NotNull;
import jakarta.annotation.Nonnull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public class UploadDocsPrinter {
    private static final LocalizationHelper LOC_HELPER = LocalizationHelper.newInstance((Locale)JuUtil.APPLICATION_LOCALE);
    private static final Font TITLE_FONT = FontFactory.getFont((String)"Helvetica", (float)14.0f, (int)1);
    private static final Font HEADER_FONT = FontFactory.getFont((String)"Helvetica", (float)11.0f, (int)1);
    private static final Font LIST_FONT = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0);
    private final Map<String, ModelItemDTO> dataModel;
    private final DocumentStore documentStore;
    private final DocumentStoreIndex index;
    private final List<EReleveDocument> erefDocuments;

    public UploadDocsPrinter(@Nonnull Map<String, ModelItemDTO> dataModel, @Nonnull DocumentStore documentStore, DocumentStoreIndex index, List<EReleveDocument> erefDocuments) {
        Objects.requireNonNull(dataModel, "Data model cannot be null.");
        Objects.requireNonNull(documentStore, "Document store cannot be null.");
        Objects.requireNonNull(index, "Index cannot be null.");
        this.dataModel = dataModel;
        this.documentStore = documentStore;
        this.index = index;
        this.erefDocuments = erefDocuments;
    }

    public void print(@Nonnull OutputStream output, @Nonnull ProgressMonitor monitor) throws DocumentException, IOException {
        com.lowagie.text.List extraLst;
        Objects.requireNonNull(output, "Output stream cannot be null.");
        Objects.requireNonNull(monitor, "Progress monitor cannot be null.");
        monitor.beginTask("label.dialog.upload.archivegeneration.justificatifs", this.index.getAllUserDocuments().size());
        ByteArrayOutputStream frontPageBuffer = new ByteArrayOutputStream();
        Image checkedImg = this.loadCheckboxImage("checked.png");
        Image uncheckedImg = this.loadCheckboxImage("unchecked.png");
        String taxPaxerNumber = (String)DataModelUtil.getRequiredValue(this.dataModel, String.class, (String)"Stammdaten.Declaration.NoContribuable");
        Document doc = new Document(PageSize.A4);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)frontPageBuffer);
        doc.open();
        writer.setCloseStream(false);
        float titleSpaceBefore = 6.0f;
        doc.add((Element)new Phrase(LOC_HELPER.translate("archive.justificatifs.front.name", new Object[]{DataModelUtil.getRequiredValue(this.dataModel, String.class, (String)"Stammdaten.PrintAdresseNomPrenom"), taxPaxerNumber}) + "\n"));
        Paragraph p = new Paragraph(LOC_HELPER.translate("archive.justificatifs.front.title", new Object[0]) + "\n", TITLE_FONT);
        p.setSpacingBefore(6.0f);
        doc.add((Element)p);
        ResolvedCategories resolvedCategories = this.index.getResolvedCategories();
        Map<ResolvedCategory, Set<ResolvedDocument>> resolvedMap = resolvedCategories.getResolvedMap();
        if (resolvedCategories.isAllRequired()) {
            doc.add((Element)new Chunk(LOC_HELPER.translate("archive.justificatifs.front.allRequired", new Object[0]) + "\n", LIST_FONT));
        } else if (resolvedMap.isEmpty()) {
            doc.add((Element)new Chunk(LOC_HELPER.translate("archive.justificatifs.front.none", new Object[0]) + "\n", LIST_FONT));
        } else {
            for (Map.Entry<ResolvedCategory, Set<ResolvedDocument>> entry : resolvedMap.entrySet()) {
                p = new Paragraph(entry.getKey().getLabel(this.dataModel) + "\n", HEADER_FONT);
                p.setSpacingBefore(2.0f);
                doc.add((Element)p);
                for (ResolvedDocument resolvedDoc : entry.getValue()) {
                    boolean docProvided = !this.index.getResolvedUserDocs(resolvedDoc).isEmpty();
                    Phrase phrase = new Phrase();
                    phrase.add((Element)new Chunk(docProvided ? checkedImg : uncheckedImg, 0.0f, -2.0f));
                    phrase.add((Element)new Chunk((DrawInterface)new VerticalPositionMark(), 17.0f, false));
                    phrase.add((Element)new Chunk(resolvedDoc.getLabel(this.dataModel) + "\n", LIST_FONT));
                    doc.add((Element)phrase);
                }
            }
        }
        List<ExtraUserDocument> extraDocs = this.index.getExtraDocs();
        if (!extraDocs.isEmpty()) {
            if (!resolvedCategories.isAllRequired()) {
                p = new Paragraph(LOC_HELPER.translate("archive.justificatifs.front.extra", new Object[0]) + "\n", TITLE_FONT);
                p.setSpacingBefore(6.0f);
                doc.add((Element)p);
            }
            extraLst = new com.lowagie.text.List(false);
            for (ExtraUserDocument extraDoc : extraDocs) {
                extraLst.add((Element)new ListItem(extraDoc.getDescription(), LIST_FONT));
            }
            doc.add((Element)extraLst);
        }
        if (!this.erefDocuments.isEmpty()) {
            p = new Paragraph(LOC_HELPER.translate("archive.justificatifs.front.eref", new Object[0]) + "\n", TITLE_FONT);
            p.setSpacingBefore(6.0f);
            doc.add((Element)p);
            extraLst = new com.lowagie.text.List(false);
            for (EReleveDocument erefDocument : this.erefDocuments) {
                extraLst.add((Element)new ListItem(erefDocument.getFileName(), LIST_FONT));
            }
            doc.add((Element)extraLst);
        }
        doc.close();
        doc = new Document(PageSize.A4);
        PdfCopy copyWriter = new PdfCopy(doc, output);
        doc.open();
        copyWriter.setCloseStream(false);
        PdfReader reader = new PdfReader((InputStream)new ByteArrayInputStream(frontPageBuffer.toByteArray()));
        for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
            PdfImportedPage frontPage = copyWriter.getImportedPage(reader, i);
            if (i == 1) {
                PdfCopy.PageStamp frontPageStamper = copyWriter.createPageStamp(frontPage);
                new PdfOutline(frontPageStamper.getOverContent().getRootOutline(), PdfAction.gotoLocalPage((int)1, (PdfDestination)new PdfDestination(1), (PdfWriter)copyWriter), LOC_HELPER.translate("archive.justificatifs.front", new Object[0]));
            }
            copyWriter.addPage(frontPage);
        }
        copyWriter.freeReader(reader);
        reader.close();
        int crtPage = writer.getCurrentPageNumber();
        for (Map.Entry<ResolvedCategory, Set<ResolvedDocument>> entry : resolvedMap.entrySet()) {
            ResolvedCategory category = entry.getKey();
            PdfOutline categoryOutline = null;
            for (ResolvedDocument resolvedDocument : entry.getValue()) {
                PdfOutline documentOutline = null;
                for (MappedUserDocument mappedUserDoc : this.index.getResolvedUserDocs(resolvedDocument)) {
                    byte[] documentBytes = this.documentStore.readDocument(mappedUserDoc.getHandle()).orElseThrow(() -> new IllegalStateException("Could not read document for handle: " + String.valueOf(mappedUserDoc.getHandle())));
                    reader = new PdfReader(documentBytes);
                    for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                        PdfImportedPage page = copyWriter.getImportedPage(reader, i);
                        if (categoryOutline == null) {
                            PdfCopy.PageStamp stamper = copyWriter.createPageStamp(page);
                            categoryOutline = new PdfOutline(stamper.getOverContent().getRootOutline(), PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)copyWriter), category.getLabel(this.dataModel));
                        }
                        if (documentOutline == null) {
                            documentOutline = new PdfOutline(categoryOutline, PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)copyWriter), resolvedDocument.getLabel(this.dataModel));
                        }
                        copyWriter.addPage(page);
                        ++crtPage;
                    }
                    copyWriter.freeReader(reader);
                    reader.close();
                    monitor.worked(1);
                }
            }
        }
        crtPage = this.addExtraDocuments(monitor, extraDocs, copyWriter, crtPage);
        this.addErefDocuments(monitor, copyWriter, crtPage);
        doc.close();
        monitor.done();
    }

    private int addExtraDocuments(@NotNull ProgressMonitor monitor, List<ExtraUserDocument> extraDocs, PdfCopy copyWriter, int crtPage) throws IOException {
        if (!extraDocs.isEmpty()) {
            PdfOutline sectionOutline = null;
            for (ExtraUserDocument extraDoc : extraDocs) {
                byte[] documentBytes = this.documentStore.readDocument(extraDoc.getHandle()).orElseThrow(() -> new IllegalStateException("Could not read extra document for handle: " + String.valueOf(extraDoc.getHandle())));
                PdfReader reader = new PdfReader(documentBytes);
                PdfOutline documentOutline = null;
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    PdfImportedPage page = copyWriter.getImportedPage(reader, i);
                    if (sectionOutline == null) {
                        PdfCopy.PageStamp stamper = copyWriter.createPageStamp(page);
                        sectionOutline = new PdfOutline(stamper.getOverContent().getRootOutline(), PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)copyWriter), LOC_HELPER.translate("archive.justificatifs.extra", new Object[0]));
                    }
                    if (documentOutline == null) {
                        documentOutline = new PdfOutline(sectionOutline, PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)copyWriter), extraDoc.getDescription());
                    }
                    copyWriter.addPage(page);
                    ++crtPage;
                }
                copyWriter.freeReader(reader);
                reader.close();
                monitor.worked(1);
            }
        }
        return crtPage;
    }

    private void addErefDocuments(@NotNull ProgressMonitor monitor, PdfCopy copyWriter, int crtPage) throws IOException {
        if (!this.erefDocuments.isEmpty()) {
            PdfOutline sectionOutline = null;
            for (EReleveDocument erefDocument : this.erefDocuments) {
                byte[] documentBytes;
                if (erefDocument.getTaxStatementPdf() == null || (documentBytes = erefDocument.getTaxStatementPdf().getFileData()) == null) continue;
                PdfReader reader = new PdfReader(documentBytes);
                PdfOutline documentOutline = null;
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    PdfImportedPage page = copyWriter.getImportedPage(reader, i);
                    if (sectionOutline == null) {
                        PdfCopy.PageStamp stamper = copyWriter.createPageStamp(page);
                        sectionOutline = new PdfOutline(stamper.getOverContent().getRootOutline(), PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)copyWriter), LOC_HELPER.translate("archive.justificatifs.eref", new Object[0]));
                    }
                    if (documentOutline == null) {
                        documentOutline = new PdfOutline(sectionOutline, PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)copyWriter), erefDocument.getFileName());
                    }
                    copyWriter.addPage(page);
                    ++crtPage;
                }
                copyWriter.freeReader(reader);
                reader.close();
                monitor.worked(1);
            }
        }
    }

    private Image loadCheckboxImage(String resName) throws IOException, BadElementException {
        assert (resName != null);
        Image img = Image.getInstance((byte[])IOUtils.toByteArray((InputStream)ArchiveGenerationTask.class.getResourceAsStream(resName)));
        img.scaleToFit(LIST_FONT.getSize(), LIST_FONT.getSize());
        return img;
    }
}

