/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.common.engine.util.DataModelUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.SystemInfo;
import ch.dvbern.tax.ju.engine.justificatifs.DocumentStoreIndex;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategories;
import jakarta.json.Json;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.OutputStream;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UploadInfo {
    private static final JsonGeneratorFactory JSON_GEN_FTY = Json.createGeneratorFactory(Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true));
    private int year;
    private String taxPayerNumber;
    private String fullname;
    private String emailContact;
    private boolean allRequiredDocsAttached;
    private SystemInfo sysInfo;
    private String codeDI;
    private DocsRequired docsRequired;

    public static @NonNull Builder newBuilder(@NonNull Map<String, ModelItemDTO> dataModel, DocumentStoreIndex index) {
        dataModel = Objects.requireNonNull(dataModel, "Data modelcannot be null.");
        Builder builder = new Builder();
        UploadInfo info = builder.info;
        info.year = ((Number)DataModelUtil.getRequiredValue(dataModel, Number.class, (String)"Stammdaten.Declaration.PeriodeTaxation")).intValue();
        info.taxPayerNumber = (String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.Declaration.NoContribuable");
        String fullname = (String)DataModelUtil.getRequiredValue(dataModel, String.class, (String)"Stammdaten.PrintAdresseNomPrenom");
        if (fullname.isEmpty()) {
            throw new IllegalArgumentException("Tax payer and partner full names must be non-empty.");
        }
        info.fullname = fullname;
        info.emailContact = (String)DataModelUtil.getValue(dataModel, String.class, (String)"Stammdaten.Declaration.AdresseEmail");
        if (index != null) {
            DocsRequired docsRequired;
            ResolvedCategories resolvedCategories = index.getResolvedCategories();
            info.allRequiredDocsAttached = false;
            if (resolvedCategories.isAllRequired()) {
                docsRequired = DocsRequired.ALL;
            } else if (resolvedCategories.getResolvedMap().isEmpty()) {
                docsRequired = DocsRequired.NONE;
            } else {
                docsRequired = DocsRequired.LIST;
                info.allRequiredDocsAttached = resolvedCategories.isUserDocumentsAllowed() && index.isEveryResolvedDocumentMapped();
            }
            info.docsRequired = docsRequired;
        }
        return builder;
    }

    public int getYear() {
        return this.year;
    }

    public String getTaxPayerNumber() {
        return this.taxPayerNumber;
    }

    public String getCodeDI() {
        return this.codeDI;
    }

    public SystemInfo getSysInfo() {
        return this.sysInfo;
    }

    public void saveInfoFile(OutputStream out) {
        JsonGenerator generator = this.nullSafeGenerator(JSON_GEN_FTY.createGenerator(out)).writeStartObject().write("year", this.year).write("tax_payer_number", this.taxPayerNumber).write("fullname", this.fullname).write("email_contact", this.emailContact).write("all_required_docs_attached", this.allRequiredDocsAttached);
        if (this.docsRequired != null) {
            generator.write("docs_required", this.docsRequired.name().toLowerCase());
        }
        generator.write("code_di", this.codeDI).writeEnd().flush();
    }

    private JsonGenerator nullSafeGenerator(JsonGenerator generator) {
        Object proxy = Proxy.newProxyInstance(generator.getClass().getClassLoader(), new Class[]{JsonGenerator.class}, (proxy1, method, args) -> {
            String methodName = method.getName();
            if (methodName.equals("write") && args.length == 2 && args[1] == null) {
                generator.writeNull((String)args[0]);
                return proxy1;
            }
            JsonGenerator.class.getMethod(methodName, method.getParameterTypes()).invoke((Object)generator, args);
            return proxy1;
        });
        return (JsonGenerator)proxy;
    }

    public static class Builder {
        private UploadInfo info = new UploadInfo();

        public Builder withCodeDI(String codeDI) {
            this.info.codeDI = codeDI;
            return this;
        }

        public Builder withSystemInfo(@Nullable SystemInfo sysInfo) {
            this.info.sysInfo = sysInfo;
            return this;
        }

        public UploadInfo build() {
            UploadInfo info = this.info;
            this.info = null;
            return info;
        }
    }

    private static enum DocsRequired {
        ALL,
        LIST,
        NONE;

    }
}

