/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.ju.Environment;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import java.util.ServiceLoader;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class UploadServiceClientFactory {
    private static final ServiceLoader<UploadServiceClientFactory> UPLOAD_SERVICE_CLIENT_FACTORY_LOADER = ServiceLoader.load(UploadServiceClientFactory.class);

    public static @NonNull UploadServiceClient login(NoContribuable numeroContribuable, int year) {
        if (numeroContribuable == null) {
            throw new NullPointerException("Tax payer number cannot be null");
        }
        if (year < 1) {
            throw new IllegalArgumentException("Fiscal year mut be a positive and non-zero");
        }
        Environment environment = Environment.getCurrentEnvironment();
        for (UploadServiceClientFactory factory : UPLOAD_SERVICE_CLIENT_FACTORY_LOADER) {
            UploadServiceClient client = factory.login(environment, numeroContribuable, year);
            if (client == null) continue;
            return client;
        }
        throw new IllegalStateException(String.format("Cannot locate client implementation for current environment (%s).", new Object[]{environment}));
    }

    protected abstract UploadServiceClient login(Environment var1, NoContribuable var2, int var3);
}

