/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import ch.dvbern.tax.ju.upload.UploadDataSource;
import ch.dvbern.tax.ju.upload.UploadServiceClient;
import ch.dvbern.tax.ju.upload.UploadServiceException;
import ch.dvbern.tax.ju.upload.UploadStatusDTO;
import ch.dvbern.tax.ju.upload.UploadValidationStatus;
import jakarta.activation.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadServiceMockClient
implements UploadServiceClient {
    private static final Logger LOG = LoggerFactory.getLogger(UploadServiceMockClient.class);
    public static final NoContribuable FAIL_NUMBER = NoContribuable.parse("200.634.300.19");
    private static final Map<NoContribuable, List<UploadStatusDTO>> MOCKED_BACKEND = new ConcurrentHashMap<NoContribuable, List<UploadStatusDTO>>();
    private final int year;
    private final NoContribuable numeroContribuable;
    private volatile boolean active = true;

    UploadServiceMockClient(NoContribuable numeroContribuable, int year) {
        this.year = year;
        this.numeroContribuable = numeroContribuable;
    }

    @Override
    public synchronized @NonNull UUID upload(@NonNull UploadDataSource archive) throws IOException, InterruptedException, UploadServiceException {
        return this.uploadInternal(this.year, this.numeroContribuable, archive, null);
    }

    @Override
    public @NonNull UUID uploadWithCodeDI(@NonNull UploadDataSource archive, @NonNull String codeDI) throws InterruptedException, IOException, UploadServiceException {
        if (codeDI == null) {
            throw new NullPointerException("Invalid null argument");
        }
        return this.uploadInternal(this.year, this.numeroContribuable, archive, codeDI);
    }

    private UUID uploadInternal(int year, @NonNull NoContribuable numeroContribuable, @NonNull DataSource archive, @Nullable String codeDI) throws InterruptedException, IOException, UploadServiceException {
        int c;
        if (year < 0) {
            throw new IllegalArgumentException("Invalid year: " + year);
        }
        Objects.requireNonNull(numeroContribuable);
        Objects.requireNonNull(archive);
        if (numeroContribuable.equals(FAIL_NUMBER)) {
            throw new UploadServiceException("Simulated error", null, "SIMULATED");
        }
        this.checkActive();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        InputStream in = archive.getInputStream();
        while ((c = in.read(buffer)) >= 0) {
            baos.write(buffer, 0, c);
            Thread.sleep(25L);
        }
        File tmpArchive = File.createTempFile("ju_upload_mock_", ".zip");
        FileUtils.writeByteArrayToFile((File)tmpArchive, (byte[])baos.toByteArray());
        LOG.info("Upload archive saved to disk: {} ({} bytes).", (Object)tmpArchive, (Object)baos.toByteArray().length);
        UUID guid = UUID.randomUUID();
        UploadValidationStatus validationStatus = codeDI != null ? UploadValidationStatus.VALIDATED_WITH_CODE_DI : UploadValidationStatus.NOT_VALIDATED;
        UploadStatusDTO status = new UploadStatusDTO(Instant.now(), guid, validationStatus, codeDI);
        List statuses = MOCKED_BACKEND.computeIfAbsent(numeroContribuable, k -> new ArrayList());
        statuses.add(status);
        return guid;
    }

    @Override
    public synchronized @NonNull List<UploadStatusDTO> getUploadStatus(@NonNull Collection<UUID> guids) {
        this.checkActive();
        if (this.year < 0) {
            throw new IllegalArgumentException("Invalid year: " + this.year);
        }
        if (this.numeroContribuable == null || guids == null) {
            throw new NullPointerException("Invalid null argument");
        }
        if (guids.isEmpty()) {
            return Collections.emptyList();
        }
        Collection statuses = MOCKED_BACKEND.get(this.numeroContribuable);
        if (statuses == null) {
            return Collections.emptyList();
        }
        ArrayList<UploadStatusDTO> result = new ArrayList<UploadStatusDTO>(guids.size());
        block0: for (UUID guid : guids) {
            for (UploadStatusDTO status : statuses) {
                if (!status.getGuid().equals(guid)) continue;
                result.add(status);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public synchronized boolean isValidationPerformed() {
        this.checkActive();
        if (this.year < 0) {
            throw new IllegalArgumentException("Invalid year: " + this.year);
        }
        if (this.numeroContribuable == null) {
            throw new NullPointerException("Invalid null argument");
        }
        Collection statuses = MOCKED_BACKEND.get(this.numeroContribuable);
        if (statuses == null) {
            return false;
        }
        for (UploadStatusDTO status : statuses) {
            if (status.getValidationStatus() == UploadValidationStatus.NOT_VALIDATED) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized @NonNull URL getValidationURL(@NonNull NoContribuable numeroContribuable, @NonNull UUID guid, @NonNull UploadConfiguration.UploadType uploadType) {
        try {
            Collection<List<UploadStatusDTO>> allStatuses = MOCKED_BACKEND.values();
            block2: for (List<UploadStatusDTO> statuses : allStatuses) {
                ListIterator<UploadStatusDTO> itr = statuses.listIterator();
                while (itr.hasNext()) {
                    UploadStatusDTO status = itr.next();
                    if (!guid.equals(status.getGuid())) continue;
                    itr.set(new UploadStatusDTO(status.getTimestamp(), guid, uploadType == UploadConfiguration.UploadType.WITH_CODE_DI ? UploadValidationStatus.VALIDATED_WITH_CODE_DI : UploadValidationStatus.VALIDATED_WITH_SWISSID, "10-342-16"));
                    break block2;
                }
            }
            return new URL("https://www.jura.ch");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void sendUploadLog(@NonNull byte[] logArchive, @NonNull String source, @NonNull UUID correlationId) throws InterruptedException {
        Objects.requireNonNull(logArchive, "Log-archive stream cannot be null");
        Objects.requireNonNull(source, "Error source cannot be null");
        Objects.requireNonNull(correlationId, "Correlation ID cannot be null");
        this.checkActive();
        Thread.sleep(5000L);
    }

    @Override
    public boolean isCodeDIValid(@NonNull String codeDI) {
        Objects.requireNonNull(codeDI, "code di cannot be null");
        return true;
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public @NonNull String getDescription() {
        return "Mocked upload service client [" + this.year + "] [" + String.valueOf(this.numeroContribuable) + "] [active: " + this.active + "]";
    }

    @Override
    public void shutdown() {
        this.active = false;
    }

    @Override
    public @NonNull NoContribuable getNumeroContribuable() {
        return this.numeroContribuable;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    private void checkActive() {
        if (!this.active) {
            throw new IllegalStateException("Client already shut down");
        }
    }
}

