/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.upload;

import ch.dvbern.tax.ju.upload.UploadValidationStatus;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class UploadStatusDTO
implements Serializable {
    private static final long serialVersionUID = 2258796809886935162L;
    private final UUID guid;
    private final Instant timestamp;
    private final UploadValidationStatus validationStatus;
    private final String declarationCode;
    private final int hashcode;

    public UploadStatusDTO(@NonNull Instant timestamp, @NonNull UUID guid, @NonNull UploadValidationStatus validationStatus, @Nullable String declarationCode) {
        this.timestamp = timestamp;
        this.guid = guid;
        this.validationStatus = validationStatus;
        this.declarationCode = declarationCode;
        Objects.requireNonNull(timestamp, "Timestamp cannot be null.");
        Objects.requireNonNull(guid, "GUID cannot be null.");
        Objects.requireNonNull(validationStatus, "Validation status cannot be null.");
        this.hashcode = new HashCodeBuilder(29387, 35099).append((Object)timestamp).append((Object)guid).append((Object)validationStatus).append((Object)declarationCode).toHashCode();
    }

    public UUID getGuid() {
        return this.guid;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public UploadValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public String getDeclarationCode() {
        return this.declarationCode;
    }

    public String toString() {
        return UploadStatusDTO.class.getName() + ": { timestamp: " + String.valueOf(this.timestamp) + ", guid: " + String.valueOf(this.guid) + ", validation status: " + String.valueOf((Object)this.validationStatus) + " }";
    }

    public boolean equals(Object obj) {
        if (obj instanceof UploadStatusDTO) {
            UploadStatusDTO status = (UploadStatusDTO)obj;
            return this.guid.equals(status.guid) && this.timestamp.equals(status.timestamp) && this.validationStatus == status.getValidationStatus();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.hashcode;
    }
}

