/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.utils;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.utils.InternalFailureException;
import java.text.MessageFormat;

public final class ErrorCode
extends Enum<ErrorCode> {
    public static final /* enum */ ErrorCode GENERIC = new ErrorCode("0000", "label.error.generic");
    public static final /* enum */ ErrorCode AUTHENTICATION = new ErrorCode("3000", "label.error.auth");
    public static final /* enum */ ErrorCode AUTHENTICATION_REQUIRED = new ErrorCode("3001", "label.error.auth.required");
    public static final /* enum */ ErrorCode EXPIRED_VIEW = new ErrorCode("3002", "label.error.auth.expired");
    public static final /* enum */ ErrorCode CONCURRENT_ACCESS = new ErrorCode("3003", "label.error.auth.concurrentaccess");
    public static final /* enum */ ErrorCode ENVIRONMENT = new ErrorCode("5000", "label.error.env");
    public static final /* enum */ ErrorCode DATABASE = new ErrorCode("5001", "label.error.env.database");
    public static final /* enum */ ErrorCode CONFIGURATION = new ErrorCode("5003", "label.error.env.configuration");
    public static final /* enum */ ErrorCode SIGNATURE = new ErrorCode("5004", "label.error.signature");
    public static final /* enum */ ErrorCode WRONG_MOBILE_NUMBER = new ErrorCode("5005", "label.error.wrong.mobile.number");
    public static final /* enum */ ErrorCode INTERNAL = new ErrorCode("9000", "label.error.internal");
    private static final String FORMAT_STRING = "[{0}] - {1}";
    private final String code;
    private final String labelKey;
    private static final /* synthetic */ ErrorCode[] $VALUES;

    public static ErrorCode[] values() {
        return (ErrorCode[])$VALUES.clone();
    }

    public static ErrorCode valueOf(String name) {
        return Enum.valueOf(ErrorCode.class, name);
    }

    private ErrorCode(String code, String labelKey) {
        assert (code != null && labelKey != null);
        this.code = code;
        this.labelKey = labelKey;
    }

    public String code() {
        return this.code;
    }

    public String labelKey() {
        return this.labelKey;
    }

    public String format(Object ... arguments) {
        try {
            String msg = JuUtil.translate(this.labelKey, arguments);
            return MessageFormat.format(FORMAT_STRING, this.code, msg);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new InternalFailureException("Failed to translate message string", e);
        }
    }

    private static /* synthetic */ ErrorCode[] $values() {
        return new ErrorCode[]{GENERIC, AUTHENTICATION, AUTHENTICATION_REQUIRED, EXPIRED_VIEW, CONCURRENT_ACCESS, ENVIRONMENT, DATABASE, CONFIGURATION, SIGNATURE, WRONG_MOBILE_NUMBER, INTERNAL};
    }

    static {
        $VALUES = ErrorCode.$values();
    }
}

