/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.utils;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TaxStatementModelMap {
    private final @NonNull DMK rowDmk;
    private final @NonNull Map<String, ModelItemDTO> changes = new LinkedHashMap<String, ModelItemDTO>();

    public TaxStatementModelMap(@NonNull DMK dmk) {
        this.rowDmk = Objects.requireNonNull(dmk);
    }

    public @NonNull TaxStatementModelMap add(@NonNull String lmkPart, @Nullable Object value) {
        Objects.requireNonNull(lmkPart);
        DMK dmk = this.rowDmk.merge(this.rowDmk.toLMK().append(lmkPart));
        ModelItemDTO mi = this.createItem(value, 1, true);
        this.changes.put(dmk.toExternalForm(), mi);
        return this;
    }

    public @NonNull TaxStatementModelMap addMissing(@NonNull String lmkPart, @Nullable Object value) {
        Objects.requireNonNull(lmkPart);
        DMK dmk = this.rowDmk.merge(this.rowDmk.toLMK().append(lmkPart));
        ModelItemDTO mi = this.createItem(value, 3, false);
        this.changes.put(dmk.toExternalForm(), mi);
        return this;
    }

    private @NonNull ModelItemDTO createItem(@Nullable Object value, int state, boolean touch) {
        ModelItemDTO result = new ModelItemDTO(value, state);
        if (touch) {
            return result.cloneTouched();
        }
        return result;
    }

    public @NonNull Map<String, ModelItemDTO> getChanges() {
        return Collections.unmodifiableMap(this.changes);
    }

    public void clear() {
        this.changes.clear();
    }
}

