/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.ejb.util;

import ch.dvbern.tax.common.transfer.dto.ResourceBundleManager;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDIHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CDIHelper.class);
    private static final CDISupport CDI_SUPPORT = CDIHelper.isClassAvailable("jakarta.enterprise.inject.spi.CDI") ? CDISupport.FULL : (CDIHelper.isClassAvailable("jakarta.enterprise.inject.spi.BeanManager") ? CDISupport.CDI_1_0 : CDISupport.NO_CDI);

    private static boolean isClassAvailable(String name) {
        assert (name != null);
        try {
            Class.forName(name, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static <T> @NonNull T get(@NonNull Class<T> target, Annotation ... annotations) {
        if (target == null) {
            throw new NullPointerException("Bean target class cannot be null.");
        }
        switch (CDI_SUPPORT.ordinal()) {
            case 0: {
                return CDIResolver.resolve(target, annotations);
            }
            case 1: {
                return CDI10Resolver.resolve(target, annotations);
            }
            case 2: {
                ServiceLoader<T> loader = ServiceLoader.load(target);
                try {
                    return loader.iterator().next();
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException(String.format("No CDI available and no service provider matching %s found.", target), e);
                }
            }
        }
        throw new AssertionError((Object)("Unknown enum member: " + String.valueOf((Object)CDI_SUPPORT)));
    }

    public static ResourceBundleManager getResourceBundleManager() {
        return CDIHelper.get(ResourceBundleManager.class, new Annotation[0]);
    }

    static {
        LOG.info("CDI support level: {}.", (Object)CDI_SUPPORT);
    }

    private static enum CDISupport {
        FULL,
        CDI_1_0,
        NO_CDI;

    }

    private static class CDIResolver {
        private CDIResolver() {
        }

        static <T> T resolve(@NonNull Class<T> target, Annotation ... annotations) {
            return (T)CDI.current().select(target, annotations).get();
        }
    }

    private static class CDI10Resolver {
        private CDI10Resolver() {
        }

        static <T> T resolve(@NonNull Class<T> target, Annotation ... annotations) {
            BeanManager beanManager;
            try {
                beanManager = (BeanManager)new InitialContext().lookup("java:comp/BeanManager");
            }
            catch (NamingException e) {
                throw new IllegalStateException("Cannot retrieve ");
            }
            Set beans = beanManager.getBeans(target, annotations);
            Bean bean = beanManager.resolve(beans);
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Failed to resolve bean for target type %s and annotations %s.", target, Arrays.toString(annotations)));
            }
            Object instance = beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext((Contextual)bean));
            return (T)instance;
        }
    }
}

