/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.oss.construct.ConstructionException;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ParserAlreadyRegisteredException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ResourceChangeListener;
import ch.dvbern.oss.construct.xml.ResourceLocator;
import ch.dvbern.oss.construct.xml.ResourceNotFoundException;
import ch.dvbern.oss.construct.xml.XMLObjectConstructor;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.DataResourceBase;
import ch.dvbern.tax.common.engine.DebugItem;
import ch.dvbern.tax.common.engine.ExpertUpdatePreprocessor;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModel;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.LogicModelItemInfoDTO;
import ch.dvbern.tax.common.engine.ModelRoot;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.calcitems.AND;
import ch.dvbern.tax.common.engine.calcitems.Abs;
import ch.dvbern.tax.common.engine.calcitems.AbsRef;
import ch.dvbern.tax.common.engine.calcitems.CFStartOrEndOfYear;
import ch.dvbern.tax.common.engine.calcitems.Coalesce;
import ch.dvbern.tax.common.engine.calcitems.Concat;
import ch.dvbern.tax.common.engine.calcitems.Constant;
import ch.dvbern.tax.common.engine.calcitems.CutCopy;
import ch.dvbern.tax.common.engine.calcitems.Divide;
import ch.dvbern.tax.common.engine.calcitems.Equals;
import ch.dvbern.tax.common.engine.calcitems.Event;
import ch.dvbern.tax.common.engine.calcitems.FormatDate;
import ch.dvbern.tax.common.engine.calcitems.GenericCompare;
import ch.dvbern.tax.common.engine.calcitems.InRange;
import ch.dvbern.tax.common.engine.calcitems.IsNull;
import ch.dvbern.tax.common.engine.calcitems.IsNullOrZero;
import ch.dvbern.tax.common.engine.calcitems.Length;
import ch.dvbern.tax.common.engine.calcitems.MinOrMaxValue;
import ch.dvbern.tax.common.engine.calcitems.Minus;
import ch.dvbern.tax.common.engine.calcitems.Modulo;
import ch.dvbern.tax.common.engine.calcitems.Multiply;
import ch.dvbern.tax.common.engine.calcitems.NOT;
import ch.dvbern.tax.common.engine.calcitems.NotEquals;
import ch.dvbern.tax.common.engine.calcitems.Null;
import ch.dvbern.tax.common.engine.calcitems.OR;
import ch.dvbern.tax.common.engine.calcitems.Opposite;
import ch.dvbern.tax.common.engine.calcitems.Paste;
import ch.dvbern.tax.common.engine.calcitems.Percent;
import ch.dvbern.tax.common.engine.calcitems.Plus;
import ch.dvbern.tax.common.engine.calcitems.Power;
import ch.dvbern.tax.common.engine.calcitems.RelRef;
import ch.dvbern.tax.common.engine.calcitems.Round;
import ch.dvbern.tax.common.engine.calcitems.RoundFiveCents;
import ch.dvbern.tax.common.engine.calcitems.SelectRef;
import ch.dvbern.tax.common.engine.calcitems.Substring;
import ch.dvbern.tax.common.engine.calcitems.Summe;
import ch.dvbern.tax.common.engine.calcitems.SystemPropertyGetter;
import ch.dvbern.tax.common.engine.calcitems.ToString;
import ch.dvbern.tax.common.engine.calcitems.ValueIfEqual;
import ch.dvbern.tax.common.engine.calcitems.ValueIfNotEqual;
import ch.dvbern.tax.common.engine.calcitems.ValueIfTrue;
import ch.dvbern.tax.common.engine.calcitems.ValuesIfEqual;
import ch.dvbern.tax.common.engine.calcitems.ValuesIfTrue;
import ch.dvbern.tax.common.engine.calcitems.YearFromDate;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode1DItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DContainerItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.CustomPrinterItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertButtonItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelAddOn;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLabelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertLinkItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListIteratorItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListLabelRowItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListValueRowItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableColumn;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableGridItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertTableMerge;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertValueItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertWizardLinkItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExtraPagesSumItem;
import ch.dvbern.tax.common.engine.expertdisplay.FontXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.ImageXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.PatternXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.RectangleXMLFactory;
import ch.dvbern.tax.common.engine.expertdisplay.ValuePositionXMLFactory;
import ch.dvbern.tax.common.engine.modelitems.Bool;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.modelitems.CalcInteger;
import ch.dvbern.tax.common.engine.modelitems.File;
import ch.dvbern.tax.common.engine.modelitems.FindFieldInTable;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.modelitems.TableConcat;
import ch.dvbern.tax.common.engine.modelitems.TableMax;
import ch.dvbern.tax.common.engine.modelitems.TableSum;
import ch.dvbern.tax.common.engine.modelitems.Text;
import ch.dvbern.tax.common.engine.modelitems.Value;
import ch.dvbern.tax.common.engine.modelitems.optionitems.ListOptionItem;
import ch.dvbern.tax.common.engine.modelitems.optionitems.SimpleOptionItem;
import ch.dvbern.tax.common.engine.modelitems.optionitems.TableOptionItem;
import ch.dvbern.tax.common.engine.util.CompareUtil;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.ExpertModelVisitor;
import ch.dvbern.tax.common.engine.util.LogicModelVisitor;
import ch.dvbern.tax.common.engine.util.WizardModelVisitor;
import ch.dvbern.tax.common.engine.validators.AutoSetDefault;
import ch.dvbern.tax.common.engine.validators.Delete;
import ch.dvbern.tax.common.engine.validators.Disabled;
import ch.dvbern.tax.common.engine.validators.DisabledIfNullOrZero;
import ch.dvbern.tax.common.engine.validators.Falsify;
import ch.dvbern.tax.common.engine.validators.GenericCompareValidator;
import ch.dvbern.tax.common.engine.validators.GenericValidator;
import ch.dvbern.tax.common.engine.validators.IfThenElse;
import ch.dvbern.tax.common.engine.validators.InputSameValidator;
import ch.dvbern.tax.common.engine.validators.Mandatory;
import ch.dvbern.tax.common.engine.validators.MatchesRegex;
import ch.dvbern.tax.common.engine.validators.NoInput;
import ch.dvbern.tax.common.engine.validators.NotNegative;
import ch.dvbern.tax.common.engine.validators.Transparent;
import ch.dvbern.tax.common.engine.validators.Trueify;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModel;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.BR;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Button;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Col;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.FileDetails;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.engine.wizarddisplay.items.FormHeaderTemplateAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Header;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Include;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Item;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Label;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Link;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowIterator;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Section;
import ch.dvbern.tax.common.engine.wizarddisplay.items.StateIndicator;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.engine.wizarddisplay.items.TableMerge;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.DvbTaxSessionWorkStatus;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceWriteDTO;
import ch.dvbern.tax.common.transfer.dto.UpdateResultDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Engine {
    private static final int CALLER_DEFAULT = 0;
    public static final int CALLER_CD = 1;
    public static final int CALLER_ONLINE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(Engine.class);
    private static final Map<String, Engine> engines = Collections.synchronizedMap(new HashMap());
    private ModelRoot modelRoot = null;
    private final Map<String, LogicModelItem> logicModelItems = new HashMap<String, LogicModelItem>(100);
    private final Map<String, LogicModelItemInfoDTO> logicModelItemsInfo;
    private final Map<String, Form> wizardDisplayModelItems = new HashMap<String, Form>();
    private final List<PersistenceReadDTO> persistenceReadDTOs = new ArrayList<PersistenceReadDTO>();
    private ExpertUpdatePreprocessor expertUpdatePreprocessor = null;
    private int caller = 0;
    private static final String JAMON_KEY_ENGINE_UPDATE = Engine.class.getName() + ".update(Map.Entry, ProtectedMap)";

    private Engine(@NonNull String xmlStructure, @Nullable DataResource dataResource, boolean verbose) throws ConstructionException {
        CustomResourceLocator locator = new CustomResourceLocator(xmlStructure);
        ParserFactory factory = new ParserFactory((ResourceLocator)locator);
        try {
            factory.registerParser("logic-model", (ElementParser)new LogicModel.XMLFactory());
            factory.registerParser("module", (ElementParser)new Module.XMLFactory());
            factory.registerParser("table", (ElementParser)new Table.XMLFactory());
            factory.registerParser("value", (ElementParser)new Value.XMLFactory());
            factory.registerParser("calc", (ElementParser)new Calc.XMLFactory());
            factory.registerParser("calc-integer", (ElementParser)new CalcInteger.XMLFactory());
            factory.registerParser("file", (ElementParser)new File.XMLFactory());
            factory.registerParser("plus", (ElementParser)new Plus.XMLFactory());
            factory.registerParser("length", (ElementParser)new Length.XMLFactory());
            factory.registerParser("minus", (ElementParser)new Minus.XMLFactory());
            factory.registerParser("power", (ElementParser)new Power.XMLFactory());
            factory.registerParser("abs", (ElementParser)new Abs.XMLFactory());
            factory.registerParser("summe", (ElementParser)new Summe.XMLFactory());
            factory.registerParser("equals", (ElementParser)new Equals.XMLFactory());
            factory.registerParser("not-equals", (ElementParser)new NotEquals.XMLFactory());
            factory.registerParser("rel-ref", (ElementParser)new RelRef.XMLFactory());
            factory.registerParser("abs-ref", (ElementParser)new AbsRef.XMLFactory());
            factory.registerParser("table-sum", (ElementParser)new TableSum.XMLFactory());
            factory.registerParser("table-concat", (ElementParser)new TableConcat.XMLFactory());
            factory.registerParser("table-max", (ElementParser)new TableMax.XMLFactory());
            factory.registerParser("find-field-in-table", (ElementParser)new FindFieldInTable.XMLFactory());
            factory.registerParser("max", (ElementParser)GenericCompareValidator.XMLFactory.MAX_FACTORY);
            factory.registerParser("min", (ElementParser)GenericCompareValidator.XMLFactory.MIN_FACTORY);
            factory.registerParser("max-strict", (ElementParser)GenericCompareValidator.XMLFactory.MAX_STRICT_FACTORY);
            factory.registerParser("min-strict", (ElementParser)GenericCompareValidator.XMLFactory.MIN_STRICT_FACTORY);
            factory.registerParser("constant", (ElementParser)new Constant.XMLFactory(dataResource));
            factory.registerParser("mandatory", (ElementParser)new Mandatory.XMLFactory());
            factory.registerParser("generic-validator", (ElementParser)new GenericValidator.XMLFactory());
            factory.registerParser("disabled-if-true", (ElementParser)new Disabled.XMLFactory(true));
            factory.registerParser("disabled-if-false", (ElementParser)new Disabled.XMLFactory(false));
            factory.registerParser("disabled-if-null-or-zero", (ElementParser)new DisabledIfNullOrZero.XMLFactory());
            factory.registerParser("transparent-if-true", (ElementParser)new Transparent.XMLFactory(true));
            factory.registerParser("transparent-if-false", (ElementParser)new Transparent.XMLFactory(false));
            factory.registerParser("text", (ElementParser)new Text.XMLFactory());
            factory.registerParser("bool", (ElementParser)new Bool.XMLFactory());
            factory.registerParser("multiply", (ElementParser)new Multiply.XMLFactory());
            factory.registerParser("divide", (ElementParser)new Divide.XMLFactory());
            factory.registerParser("modulo", (ElementParser)new Modulo.XMLFactory());
            factory.registerParser("percent", (ElementParser)new Percent.XMLFactory());
            factory.registerParser("not-negative", (ElementParser)new NotNegative.XMLFactory());
            factory.registerParser("select", (ElementParser)new Select.XMLFactory());
            factory.registerParser("option-item", (ElementParser)new SimpleOptionItem.XMLFactory());
            factory.registerParser("list-option", (ElementParser)new ListOptionItem.XMLFactory());
            factory.registerParser("select-ref", (ElementParser)new SelectRef.XMLFactory());
            factory.registerParser("table-option", (ElementParser)new TableOptionItem.XMLFactory());
            factory.registerParser("data-resource", (ElementParser)new DataResourceBase.XMLFactory(dataResource));
            factory.registerParser("model-root", (ElementParser)new ModelRoot.XMLFactory());
            factory.registerParser("and", (ElementParser)new AND.XMLFactory());
            factory.registerParser("or", (ElementParser)new OR.XMLFactory());
            factory.registerParser("opposite", (ElementParser)new Opposite.XMLFactory());
            factory.registerParser("max-value", (ElementParser)new MinOrMaxValue.XMLFactory(MinOrMaxValue.Mode.MAX, null, MinOrMaxValue.NullHandling.IGNORE, true));
            factory.registerParser("min-value", (ElementParser)new MinOrMaxValue.XMLFactory(MinOrMaxValue.Mode.MIN, null, MinOrMaxValue.NullHandling.IGNORE, true));
            factory.registerParser("delete-if-true", (ElementParser)new Delete.XMLFactory(true));
            factory.registerParser("delete-if-false", (ElementParser)new Delete.XMLFactory(false));
            factory.registerParser("is-null", (ElementParser)new IsNull.XMLFactory(true));
            factory.registerParser("not-null", (ElementParser)new IsNull.XMLFactory(false));
            factory.registerParser("is-null-or-zero", (ElementParser)new IsNullOrZero.XMLFactory(true));
            factory.registerParser("not-null-or-zero", (ElementParser)new IsNullOrZero.XMLFactory(false));
            factory.registerParser("greater", (ElementParser)new GenericCompare.XMLFactory(CompareUtil.Operator.GREATER));
            factory.registerParser("greater-or-equal", (ElementParser)new GenericCompare.XMLFactory(CompareUtil.Operator.GREATER_OR_EQUAL));
            factory.registerParser("smaller", (ElementParser)new GenericCompare.XMLFactory(CompareUtil.Operator.SMALLER));
            factory.registerParser("smaller-or-equal", (ElementParser)new GenericCompare.XMLFactory(CompareUtil.Operator.SMALLER_OR_EQUAL));
            factory.registerParser("greater-null-as-zero", (ElementParser)new GenericCompare.XMLFactory(CompareUtil.Operator.GREATER, true));
            factory.registerParser("smaller-null-as-zero", (ElementParser)new GenericCompare.XMLFactory(CompareUtil.Operator.SMALLER, true));
            factory.registerParser("in-range", (ElementParser)new InRange.XMLFactory());
            factory.registerParser("values-if-true", (ElementParser)new ValuesIfTrue.XMLFactory(true));
            factory.registerParser("values-if-false", (ElementParser)new ValuesIfTrue.XMLFactory(false));
            factory.registerParser("value-if-true", (ElementParser)new ValueIfTrue.XMLFactory(true));
            factory.registerParser("value-if-false", (ElementParser)new ValueIfTrue.XMLFactory(false));
            factory.registerParser("not", (ElementParser)new NOT.XMLFactory());
            factory.registerParser("substring", (ElementParser)new Substring.XMLFactory());
            factory.registerParser("to-string", (ElementParser)new ToString.XMLFactory());
            factory.registerParser("values-if-equal", (ElementParser)new ValuesIfEqual.XMLFactory());
            factory.registerParser("value-if-equal", (ElementParser)new ValueIfEqual.XMLFactory());
            factory.registerParser("value-if-not-equal", (ElementParser)new ValueIfNotEqual.XMLFactory());
            factory.registerParser("year-from-date", (ElementParser)new YearFromDate.XMLFactory());
            factory.registerParser("null-value", (ElementParser)new Null.XMLFactory());
            factory.registerParser("no-input", (ElementParser)new NoInput.XMLFactory());
            factory.registerParser("falsify-if-true", (ElementParser)new Falsify.XMLFactory(true));
            factory.registerParser("falsify-if-false", (ElementParser)new Falsify.XMLFactory(false));
            factory.registerParser("trueify-if-true", (ElementParser)new Trueify.XMLFactory(true));
            factory.registerParser("trueify-if-false", (ElementParser)new Trueify.XMLFactory(false));
            factory.registerParser("auto-set-default", (ElementParser)new AutoSetDefault.XMLFactory());
            factory.registerParser("zero-min", (ElementParser)new MinOrMaxValue.XMLFactory(MinOrMaxValue.Mode.MAX, 0L, MinOrMaxValue.NullHandling.DEFAULT, false));
            factory.registerParser("truncate-to-max", (ElementParser)new MinOrMaxValue.XMLFactory(MinOrMaxValue.Mode.MIN, null, MinOrMaxValue.NullHandling.NULL_AS_ZERO, false));
            factory.registerParser("increase-to-min", (ElementParser)new MinOrMaxValue.XMLFactory(MinOrMaxValue.Mode.MAX, null, MinOrMaxValue.NullHandling.NULL_AS_ZERO, false));
            factory.registerParser("matches-regex", (ElementParser)new MatchesRegex.XMLFactory());
            factory.registerParser("concat", (ElementParser)new Concat.XMLFactory());
            factory.registerParser("round", (ElementParser)new Round.XMLFactory());
            factory.registerParser("round-five", (ElementParser)new RoundFiveCents.XMLFactory());
            factory.registerParser("debug", (ElementParser)new DebugItem.XMLFactory());
            factory.registerParser("event", (ElementParser)new Event.XMLFactory());
            factory.registerParser("if", (ElementParser)new IfThenElse.XMLFactory());
            factory.registerParser("copy", (ElementParser)new CutCopy.XMLFactory(false));
            factory.registerParser("cut", (ElementParser)new CutCopy.XMLFactory(true));
            factory.registerParser("paste", (ElementParser)new Paste.XMLFactory());
            factory.registerParser("input-same", (ElementParser)new InputSameValidator.XMLFactory());
            factory.registerParser("coalesce", (ElementParser)new Coalesce.XMLFactory());
            factory.registerParser("year-start", (ElementParser)new CFStartOrEndOfYear.XMLFactory(CFStartOrEndOfYear.Mode.START));
            factory.registerParser("year-end", (ElementParser)new CFStartOrEndOfYear.XMLFactory(CFStartOrEndOfYear.Mode.END));
            factory.registerParser("system-property", (ElementParser)new SystemPropertyGetter.XMLFactory());
            factory.registerParser("format-date", (ElementParser)new FormatDate.XMLFactory());
            factory.registerParser("wizard-display-model", (ElementParser)new WizardDisplayModel.XMLFactory());
            factory.registerParser("w-form", (ElementParser)new Form.XMLFactory());
            factory.registerParser("w-section", (ElementParser)new Section.XMLFactory());
            factory.registerParser("w-col-def", (ElementParser)new ColDef.XMLFactory());
            factory.registerParser("w-help", (ElementParser)new Help.XMLFactory());
            factory.registerParser("w-row", (ElementParser)new Row.XMLFactory());
            factory.registerParser("w-row-iterator", (ElementParser)new RowIterator.XMLFactory());
            factory.registerParser("w-label", (ElementParser)new Label.XMLFactory());
            factory.registerParser("w-button", (ElementParser)new Button.XMLFactory());
            factory.registerParser("w-link", (ElementParser)new Link.XMLFactory());
            factory.registerParser("w-item", (ElementParser)new Item.XMLFactory());
            factory.registerParser("w-table", (ElementParser)new Table.XMLFactory());
            factory.registerParser("w-table-merge", (ElementParser)new TableMerge.XMLFactory());
            factory.registerParser("w-col", (ElementParser)new Col.XMLFactory());
            factory.registerParser("w-br", (ElementParser)new BR.XMLFactory());
            factory.registerParser("w-header", (ElementParser)new Header.XMLFactory());
            factory.registerParser("w-label-add-on", (ElementParser)new LabelAddOn.XMLFactory());
            factory.registerParser("w-header-template-add-on", (ElementParser)new FormHeaderTemplateAddOn.XMLFactory());
            factory.registerParser("w-include", (ElementParser)new Include.XMLFactory());
            factory.registerParser("w-file-details", (ElementParser)new FileDetails.XMLFactory());
            factory.registerParser("w-state-indicator", (ElementParser)new StateIndicator.XMLFactory());
            factory.registerParser("expert-display-model", (ElementParser)new ExpertDisplayModel.XMLFactory());
            factory.registerParser("e-button", (ElementParser)new ExpertButtonItem.XMLFactory());
            factory.registerParser("e-navigation", (ElementParser)new ExpertNavigationItem.XMLFactory());
            factory.registerParser("e-form", (ElementParser)new ExpertFormItem.XMLFactory());
            factory.registerParser("e-label-add-on", (ElementParser)new ExpertLabelAddOn.XMLFactory());
            factory.registerParser("e-label", (ElementParser)new ExpertLabelItem.XMLFactory());
            factory.registerParser("e-table-col", (ElementParser)new ExpertTableColumn.XMLFactory());
            factory.registerParser("e-table", (ElementParser)new ExpertTableItem.XMLFactory());
            factory.registerParser("e-table-grid", (ElementParser)new ExpertTableGridItem.XMLFactory());
            factory.registerParser("e-table-merge", (ElementParser)new ExpertTableMerge.XMLFactory());
            factory.registerParser("e-value", (ElementParser)new ExpertValueItem.XMLFactory());
            factory.registerParser("e-value-pos", (ElementParser)new ValuePositionXMLFactory());
            factory.registerParser("e-image", (ElementParser)new ImageXMLFactory());
            factory.registerParser("e-font", (ElementParser)new FontXMLFactory());
            factory.registerParser("e-table-font", (ElementParser)new FontXMLFactory());
            factory.registerParser("e-table-header-font", (ElementParser)new FontXMLFactory());
            factory.registerParser("e-table-title-font", (ElementParser)new FontXMLFactory());
            factory.registerParser("e-table-title-pattern", (ElementParser)new PatternXMLFactory());
            factory.registerParser("e-link", (ElementParser)new ExpertLinkItem.XMLFactory());
            factory.registerParser("e-barcode", (ElementParser)new Barcode1DItem.XMLFactory());
            factory.registerParser("e-barcode2d-container", (ElementParser)new Barcode2DContainerItem.XMLFactory());
            factory.registerParser("e-barcode2d", (ElementParser)new Barcode2DXMLFactory());
            factory.registerParser("e-rectangle", (ElementParser)new RectangleXMLFactory());
            factory.registerParser("e-list", (ElementParser)new ExpertListItem.XMLFactory());
            factory.registerParser("e-list-label", (ElementParser)new ExpertListLabelRowItem.XMLFactory());
            factory.registerParser("e-list-value", (ElementParser)new ExpertListValueRowItem.XMLFactory());
            factory.registerParser("e-list-iterator", (ElementParser)new ExpertListIteratorItem.XMLFactory());
            factory.registerParser("e-extra-pages-sum", (ElementParser)new ExtraPagesSumItem.XMLFactory());
            factory.registerParser("e-wizard-link", (ElementParser)new ExpertWizardLinkItem.XMLFactory());
            factory.registerParser("e-navigation-desc-add-on", (ElementParser)new ExpertLabelAddOn.XMLFactory());
            factory.registerParser("e-custom-printer", (ElementParser)new CustomPrinterItem.XMLFactory(dataResource));
            factory.registerParser("font", (ElementParser)new FontXMLFactory());
            Map<String, ElementParser> additionalXmlParsers = ApplicationConfig.getInstance().getAdditionalXmlParsers();
            if (additionalXmlParsers != null && !additionalXmlParsers.isEmpty()) {
                for (Map.Entry<String, ElementParser> entry : additionalXmlParsers.entrySet()) {
                    factory.registerParser(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (ParserAlreadyRegisteredException pare) {
            throw new ConstructionException((Throwable)pare);
        }
        XMLObjectConstructor constructor = new XMLObjectConstructor(factory);
        this.modelRoot = (ModelRoot)constructor.construct("<not a file input>", false);
        try {
            this.modelRoot.initializeLogicModel(this.logicModelItems, this.persistenceReadDTOs, verbose);
            this.modelRoot.initializeReferences(this.logicModelItems);
            this.modelRoot.initializeWizardDisplayModel(this.logicModelItems, this.wizardDisplayModelItems);
            this.modelRoot.initializeExpertDisplayModel(this.logicModelItems);
            this.expertUpdatePreprocessor = new ExpertUpdatePreprocessor(this.modelRoot.getLogicModel(), this.logicModelItems);
            this.logicModelItemsInfo = Collections.unmodifiableMap(LogicModelItemInfoDTO.build(this.logicModelItems));
        }
        catch (InvalidModelException ime) {
            LOG.error("Invalid model: " + ime.getMessage());
            throw new ConstructionException((Throwable)ime);
        }
    }

    public List<PersistenceReadDTO> getPersistenceReadDTOs() {
        return this.persistenceReadDTOs;
    }

    public List<PersistenceReadDTO> getPersistenceReadDTOs(String dataModelKey) {
        String dmk = EngineUtil.removeTableIndices(dataModelKey);
        ArrayList<PersistenceReadDTO> result = new ArrayList<PersistenceReadDTO>();
        for (PersistenceReadDTO prDTO : this.persistenceReadDTOs) {
            String logicModelKey = prDTO.getDataModelKeyTemplate().replaceAll("\\#\\.", "");
            if (!logicModelKey.startsWith(dmk)) continue;
            result.add(prDTO);
        }
        return result;
    }

    public Map<String, List<PersistenceWriteDTO>> initializeDefaultValues(Map<String, ModelItemDTO> dataModel) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, true);
        for (LogicModelItem lmi : this.modelRoot.getLogicModel().getTopLevelItems()) {
            lmi.initializeDefaultValues(dataModelMap, "");
        }
        this.processAsyncUpdates(dataModelMap);
        return dataModelMap.getChangedMap();
    }

    public UpdateResultDTO update(Map<String, ModelItemDTO> dataModel, Map<String, ModelItemDTO> newValues, boolean allowDelete) {
        if (dataModel == null) {
            throw new NullPointerException("Data model cannot be null.");
        }
        if (newValues == null) {
            throw new NullPointerException("Update map cannot be null.");
        }
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, allowDelete);
        for (Map.Entry<String, ModelItemDTO> element : newValues.entrySet()) {
            this.update(element, dataModelMap);
        }
        this.processAsyncUpdates(dataModelMap);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    public UpdateResultDTO update(Map<String, ModelItemDTO> dataModel, Map<String, ModelItemDTO> newValues, boolean allowDelete, DvbTaxSessionWorkStatus status) throws InterruptedException {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, allowDelete);
        int alleItems = dataModel.size();
        int count = 0;
        long einItemRun = 0L;
        long startTime = System.currentTimeMillis();
        for (Map.Entry<String, ModelItemDTO> element : newValues.entrySet()) {
            this.update(element, dataModelMap);
            ++count;
            if (status == null) continue;
            if (einItemRun == 0L) {
                einItemRun = System.currentTimeMillis() - startTime;
            }
            status.setWorkPercentageDone(100 * count / alleItems);
            long timeLeft = (long)(alleItems - count) * einItemRun / 1000L;
            status.setTimeRemaining(Long.valueOf(timeLeft).intValue());
        }
        this.processAsyncUpdates(dataModelMap);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    public UpdateResultDTO importData(Map<String, ModelItemDTO> dataModel, Map<String, ModelItemDTO> newValues, boolean allowDelete) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, allowDelete);
        dataModelMap.setRecalculating(true);
        for (Map.Entry<String, ModelItemDTO> entry : newValues.entrySet()) {
            this.update(entry, dataModelMap);
        }
        this.processAsyncUpdates(dataModelMap);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    private void processAsyncUpdates(LogicModelItem.ProtectedMap dataModelMap) {
        Map<String, ModelItemDTO> asyncUpdates = dataModelMap.getAsyncUpdates();
        while (!asyncUpdates.isEmpty()) {
            Set<Map.Entry<String, ModelItemDTO>> entries = asyncUpdates.entrySet();
            Map.Entry<String, ModelItemDTO> asyncUpdate = entries.iterator().next();
            String dmk = asyncUpdate.getKey();
            if (LOG.isDebugEnabled()) {
                LOG.debug("executing async update dmk=" + asyncUpdate.getKey() + " updates left=" + asyncUpdates.size());
            }
            if (asyncUpdate.getValue() != null) {
                this.update(asyncUpdate, dataModelMap);
            } else {
                LogicModelItem lmi = this.logicModelItems.get(EngineUtil.removeTableIndices(dmk));
                lmi.deleteValue(dataModelMap, dmk);
            }
            asyncUpdates.remove(dmk);
        }
    }

    private void update(Map.Entry<String, ModelItemDTO> itemEntry, @NonNull LogicModelItem.ProtectedMap dataModelMap) {
        String logicModelKey = EngineUtil.removeTableIndices(itemEntry.getKey());
        LogicModelItem lmi = this.logicModelItems.get(logicModelKey);
        if (lmi != null) {
            dataModelMap.getRunningLoops().clear();
            lmi.setValue(dataModelMap, itemEntry.getKey(), itemEntry.getValue(), null);
        } else {
            LOG.warn("invalid model item key: {} not found for dmk: {}", (Object)logicModelKey, (Object)itemEntry.getKey());
        }
    }

    public UpdateResultDTO update(Map<String, ModelItemDTO> dataModel, Map<String, ModelItemDTO> newValues, boolean errorForced, boolean deleteForced, @Nullable String key, boolean writeOnView, boolean demoMode) {
        UpdateResultDTO result = this.update(dataModel, newValues, true);
        WizardDisplayInfoDTO diDTO = null;
        if (key != null) {
            diDTO = this.getWizardDisplayInfo(dataModel, key, writeOnView, false, demoMode, this.caller, false).getWizardDisplayInfoDTO();
        }
        boolean undo = false;
        if (!errorForced) {
            Iterator<String> i = newValues.keySet().iterator();
            while (i.hasNext() && !undo) {
                Collection<MessageItemDTO> msgs;
                ModelItemDTO miDTO = dataModel.get(i.next());
                if (miDTO == null || (msgs = miDTO.getMessages()) == null) continue;
                Iterator<MessageItemDTO> j = msgs.iterator();
                while (j.hasNext() && !undo) {
                    if (j.next().getType() != 4) continue;
                    undo = true;
                }
            }
        }
        if (!deleteForced) {
            Collection<MessageItemDTO> deleteWarnings = result.getDeleteWarnings();
            if (diDTO != null && deleteWarnings != null && !deleteWarnings.isEmpty()) {
                undo = true;
                diDTO.setDeleteWarnings(deleteWarnings);
            }
        }
        if (undo) {
            for (Map.Entry<String, ModelItemDTO> me : result.getUndoInformations().entrySet()) {
                if (me.getValue() == null) {
                    dataModel.remove(me.getKey());
                    continue;
                }
                dataModel.put(me.getKey(), me.getValue());
            }
            result.getPersistenceWriteDTOs().clear();
        }
        if (diDTO != null) {
            result.setWizardDisplayInfoDTO(diDTO);
        }
        return result;
    }

    public UpdateResultDTO expertUpdate(@NonNull Map<String, ModelItemDTO> dataModel, @NonNull Map<String, ModelItemDTO> newValues, boolean errorForced, boolean deleteForced, String formAccessKey, Locale locale, boolean touchItems) {
        Map<String, ModelItemDTO> values = this.expertUpdatePreprocessor.preProcessExpertUpdate(dataModel, newValues);
        UpdateResultDTO result = this.update(dataModel, values, true);
        if (touchItems) {
            List<LogicModelItem> stateItems = this.modelRoot.getExpertDisplayModel().getFormStateItems(formAccessKey);
            Map<String, ModelItemDTO> touchValues = this.expertUpdatePreprocessor.touchModelItems(formAccessKey, stateItems, dataModel);
            UpdateResultDTO touchResult = this.update(dataModel, touchValues, true);
            result.includeOtherResultWithoutDisplayInfo(touchResult);
        }
        ExpertDisplayInfoDTO diDTO = null;
        if (formAccessKey != null) {
            ExpertDisplayInfoDTOAndChanges diAndChanges = this.getExpertDisplayInfo(dataModel, formAccessKey, locale, 1);
            diDTO = diAndChanges.getExpertDisplayInfoDTO();
            result.getPersistenceWriteDTOs().putAll(diAndChanges.getChanges());
        }
        boolean undo = false;
        if (!errorForced) {
            Iterator<String> i = values.keySet().iterator();
            while (i.hasNext() && !undo) {
                Collection<MessageItemDTO> msgs;
                ModelItemDTO miDTO = dataModel.get(i.next());
                if (miDTO == null || (msgs = miDTO.getMessages()) == null) continue;
                Iterator<MessageItemDTO> j = msgs.iterator();
                while (j.hasNext() && !undo) {
                    if (j.next().getType() != 4) continue;
                    undo = true;
                }
            }
        }
        if (!deleteForced) {
            Collection<MessageItemDTO> deleteWarnings = result.getDeleteWarnings();
            if (diDTO != null && deleteWarnings != null && !deleteWarnings.isEmpty()) {
                undo = true;
                diDTO.setDeleteWarnings(deleteWarnings);
            }
        }
        if (undo) {
            for (Map.Entry<String, ModelItemDTO> me : result.getUndoInformations().entrySet()) {
                if (me.getValue() == null) {
                    dataModel.remove(me.getKey());
                    continue;
                }
                dataModel.put(me.getKey(), me.getValue());
            }
            result.getPersistenceWriteDTOs().clear();
        }
        if (diDTO != null) {
            result.setExpertDisplayInfoDTO(diDTO);
        }
        return result;
    }

    public @NonNull WizardDisplayInfoDTOAndChanges getWizardDisplayInfo(@NonNull Map<String, ModelItemDTO> dataModel, @Nullable String key, boolean writeOnView, boolean released, boolean demoMode, int caller, boolean autoEnable) {
        this.caller = caller;
        return this.getWizardDisplayInfo(dataModel, key, writeOnView, released, demoMode, autoEnable);
    }

    public @NonNull WizardDisplayInfoDTOAndChanges getWizardDisplayInfo(@NonNull Map<String, ModelItemDTO> dataModel, @Nullable String dmk, boolean writeOnView, boolean released, boolean demoMode, boolean autoEnable) {
        Object navKey;
        Object nextKey;
        Object prevKey;
        String backKey;
        int tmoState;
        Map<String, ModelItemDTO> changes;
        boolean isTableEntryDmk;
        LogicModelItem lmi;
        if (dmk == null) {
            dmk = this.modelRoot.getLogicModel().getModuls().get(0).getName();
        }
        if ((lmi = this.logicModelItems.get(EngineUtil.removeTableIndices((String)dmk))) == null) {
            throw new InvalidModelItemKeyException("No logic model item found for DMK: " + (String)dmk);
        }
        if (EngineUtil.endsWithTableIndex((String)dmk)) {
            if (!(lmi instanceof LogicModelItem.TableItem)) {
                throw new InvalidModelItemKeyException("Not a table: " + (String)dmk);
            }
            isTableEntryDmk = true;
        } else {
            if (lmi instanceof LogicModelItem.TableItem) {
                throw new InvalidModelItemKeyException("Missing table index: " + (String)dmk);
            }
            if (!(lmi instanceof Module)) {
                throw new InvalidModelItemKeyException("Not a module: " + (String)dmk);
            }
            if (((Module)lmi).isNoNavigation()) {
                return this.getWizardDisplayInfo(dataModel, EngineUtil.removeLastKeyPart((String)dmk), writeOnView, released, demoMode, autoEnable);
            }
            isTableEntryDmk = false;
        }
        boolean isSimpleTableEntry = isTableEntryDmk;
        if (lmi.getChildren() != null) {
            for (LogicModelItem element : lmi.getChildren()) {
                if (!(element instanceof Module)) continue;
                if (!isTableEntryDmk || ((Module)element).isNoNavigation()) break;
                dmk = (String)dmk + "." + EngineUtil.getLastKeyPart(element.getName());
                isSimpleTableEntry = false;
                break;
            }
        }
        WizardDisplayModelItem.ProtectedMap protectedDataModel = new WizardDisplayModelItem.ProtectedMap(dataModel, writeOnView, this);
        if (autoEnable && !(changes = this.getAutoEnableChanges(lmi, dataModel, (String)dmk)).isEmpty()) {
            protectedDataModel.getChangedMap().putAll(this.update(dataModel, changes, false).getPersistenceWriteDTOs());
        }
        int n = tmoState = released ? 100 : this.getState(protectedDataModel);
        if (demoMode) {
            tmoState = 3;
        }
        if (isSimpleTableEntry) {
            backKey = null;
            prevKey = null;
            nextKey = null;
            LogicModelItem parent = lmi;
            while ((parent = parent.getParent()) != null && (!(parent instanceof Module) || ((Module)parent).isNoNavigation())) {
            }
            if (parent == null) {
                throw new InvalidModelItemKeyException("Cannot found navigable parent from " + (String)dmk);
            }
            navKey = EngineUtil.mergeModelKey(parent.getName(), (String)dmk);
        } else {
            nextKey = this.modelRoot.getWizardDisplayModel().getNext((String)dmk, protectedDataModel, this.logicModelItems, tmoState, this.caller);
            prevKey = this.modelRoot.getWizardDisplayModel().getPrev((String)dmk, protectedDataModel, this.logicModelItems, tmoState, this.caller);
            backKey = this.modelRoot.getWizardDisplayModel().getBack((String)dmk, this.logicModelItems);
            navKey = dmk;
        }
        String moduleLMK = EngineUtil.removeTableIndices((String)navKey);
        Module module = (Module)this.logicModelItems.get(moduleLMK);
        List<WizardDisplayInfoDTO.NavigationsItemDTO> navigationsItems = this.modelRoot.getWizardDisplayModel().getNavigationsInfo(module, protectedDataModel, this.modelRoot, (String)navKey, tmoState, this.caller);
        String formLMK = EngineUtil.removeTableIndices((String)dmk);
        Form form = this.wizardDisplayModelItems.get(formLMK);
        if (form == null) {
            throw new InvalidModelItemKeyException("no form found for " + formLMK);
        }
        ModelItemDTO prevDTO = dataModel.get(dmk);
        WizardDisplayInfoDTO.FormItemDTO formItemDTO = form.getFormInfo(protectedDataModel, (String)dmk);
        int navigationState = this.modelRoot.getWizardDisplayModel().getNavigationState(protectedDataModel, module, (String)navKey, tmoState, this.caller);
        if (navigationState == 11 || navigationState == 12) {
            throw new InvalidModelItemKeyException(String.format("Cannot access module %s from data model key %s, unsuitable state: %d", moduleLMK, dmk, navigationState));
        }
        formItemDTO.setIsTableEntry(isSimpleTableEntry);
        formItemDTO.setAllNavigationItemsTouched(this.areAllNavigationItemsTouched(navigationsItems, (String)dmk));
        ModelItemDTO postDTO = dataModel.get(dmk);
        if (!(postDTO == null || postDTO.getState() != 4 && postDTO.getState() != 2 || prevDTO != null && prevDTO.getState() == postDTO.getState())) {
            nextKey = prevKey = dmk;
        }
        WizardDisplayInfoDTO.NavigationDTO navigationDTO = new WizardDisplayInfoDTO.NavigationDTO(navigationsItems, (String)nextKey, (String)prevKey, backKey, (String)dmk, tmoState);
        WizardDisplayInfoDTO.BreadcrumbsItemDTO breadcrumbsItemDTO = this.modelRoot.getWizardDisplayModel().getBreadcrumbsRoot(this.logicModelItems, (String)dmk);
        return new WizardDisplayInfoDTOAndChanges(new WizardDisplayInfoDTO(formItemDTO, navigationDTO, breadcrumbsItemDTO), protectedDataModel.getChangedMap(), protectedDataModel.getUndoInfoMap());
    }

    private boolean areAllNavigationItemsTouched(List<WizardDisplayInfoDTO.NavigationsItemDTO> navigationItems, String currentDMK) {
        boolean result = true;
        if (navigationItems != null) {
            for (WizardDisplayInfoDTO.NavigationsItemDTO navItem : navigationItems) {
                if (!currentDMK.startsWith(navItem.getKey()) && navItem.getState() == 3) {
                    result = false;
                }
                if (this.areAllNavigationItemsTouched(navItem.getChildren(), currentDMK)) continue;
                result = false;
            }
        }
        return result;
    }

    private Map<String, ModelItemDTO> getAutoEnableChanges(LogicModelItem lmi, Map<String, ModelItemDTO> dataModel, String dmk) {
        List<Validator> validators = lmi.getValidators();
        if (lmi.isReadonly() || validators.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ModelItemDTO> updates = new HashMap<String, ModelItemDTO>();
        for (Validator v : validators) {
            if (!(v instanceof Transparent)) continue;
            Transparent t = (Transparent)v;
            for (CalcItem ci : t.getCalcItems()) {
                Object value;
                LogicModelItem ref;
                if (!(ci instanceof Reference) || !((ref = this.logicModelItems.get(((Reference)((Object)ci)).getName())) instanceof Bool) && !(ref instanceof LogicModelItem.SelectItem) || ref.isReadonly()) continue;
                String miDmk = EngineUtil.mergeModelKey(ref.getName(), dmk);
                ModelItemDTO mi = dataModel.get(miDmk);
                if (mi == null) {
                    mi = new ModelItemDTO(!t.getBooleanExpression());
                    mi.setTouched();
                    updates.put(miDmk, mi);
                    continue;
                }
                if (mi.getState() == 12 || mi.getState() == 11 || (value = mi.getValue()) != null && !Boolean.valueOf(t.getBooleanExpression()).equals(value)) continue;
                mi = mi.clone(!t.getBooleanExpression());
                mi.setTouched();
                updates.put(miDmk, mi);
            }
        }
        return updates;
    }

    public ExpertDisplayInfoDTOAndChanges getExpertDisplayInfo(@NonNull Map<String, ModelItemDTO> dataModel, @Nullable String key, @Nullable Locale locale, int mode) {
        ExpertDisplayModel.ProtectedMap protectedDataModel = new ExpertDisplayModel.ProtectedMap(dataModel, true, this);
        ExpertDisplayInfoDTO edi = this.modelRoot.getExpertDisplayModel().getExpertDisplayInfo(protectedDataModel, key, this.logicModelItems, locale, mode);
        Objects.requireNonNull(edi);
        Map<String, ModelItemDTO> values = this.expertUpdatePreprocessor.preProcessExpertUpdate(dataModel, protectedDataModel.getTableUpdates());
        UpdateResultDTO result = this.update(dataModel, values, true);
        Map<String, List<PersistenceWriteDTO>> toWrite = protectedDataModel.getChangedMap();
        toWrite.putAll(result.getPersistenceWriteDTOs());
        return new ExpertDisplayInfoDTOAndChanges(edi, toWrite);
    }

    public List<ExpertDisplayInfoDTO.NavigationDTO> getExpertNavigationItems(Map<String, ModelItemDTO> dataModel) {
        ExpertDisplayModel.ProtectedMap protectedDataModel = new ExpertDisplayModel.ProtectedMap(dataModel, false, this);
        return this.modelRoot.getExpertDisplayModel().getExpertNavigationItems(protectedDataModel);
    }

    public ChangesAndUndoInformations delete(Map<String, ModelItemDTO> dataModel, String dataModelKey) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, true);
        String logicModelKey = EngineUtil.removeTableIndices(dataModelKey);
        LogicModelItem lmi = this.logicModelItems.get(logicModelKey);
        if (lmi == null) {
            throw new InvalidModelItemKeyException(logicModelKey + " not found");
        }
        lmi.deleteValue(dataModelMap, dataModelKey);
        Iterator<Map.Entry<String, ModelItemDTO>> itr = dataModelMap.getAsyncUpdates().entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, ModelItemDTO> entry = itr.next();
            if (!entry.getKey().startsWith(dataModelKey)) continue;
            itr.remove();
        }
        this.processAsyncUpdates(dataModelMap);
        return new ChangesAndUndoInformations(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap());
    }

    public static Engine createEngine(@NonNull String xmlStructure, @Nullable DataResource dataResource, boolean verbose) throws ConstructionException {
        Engine result = new Engine(xmlStructure, dataResource, verbose);
        engines.put(result.getId(), result);
        return result;
    }

    public String getId() {
        return this.modelRoot.getName();
    }

    public static Engine getEngine(String id) {
        return engines.get(id);
    }

    public static void reloadEngines() {
        engines.clear();
        LOG.debug("engines cache cleared");
    }

    public static void setMax(Element element, List<Validator> validators) {
        if (element.getAttribute("max") != null) {
            String sValue = element.getAttributeValue("max");
            Number rhs = sValue.contains(".") ? (Number)Double.valueOf(sValue) : (Number)Long.valueOf(sValue);
            GenericCompareValidator max = new GenericCompareValidator(CompareUtil.Operator.SMALLER_OR_EQUAL, rhs, false, false, "error.value.max.default");
            validators.add(max);
        }
    }

    public static void setMin(Element element, List<Validator> validators) {
        if (element.getAttribute("min") != null) {
            String sValue = element.getAttributeValue("min");
            Number rhs = sValue.contains(".") ? (Number)Double.valueOf(sValue) : (Number)Long.valueOf(sValue);
            GenericCompareValidator min = new GenericCompareValidator(CompareUtil.Operator.GREATER_OR_EQUAL, rhs, false, false, "error.value.min.default");
            validators.add(min);
        }
    }

    public static void setMandatory(Element element, List<Validator> validators) {
        if (element.getAttribute("mandatory") != null) {
            Mandatory mandatory = new Mandatory(false, null, null);
            validators.add(mandatory);
        }
    }

    public static void setNotNegative(Element element, List<Validator> validators) {
        if (element.getAttribute("not-negative") != null) {
            NotNegative nonNegative = new NotNegative(Boolean.parseBoolean(element.getAttributeValue("not-negative")), false);
            validators.add(nonNegative);
        }
    }

    public int getDataModelState(@NonNull Map<String, ModelItemDTO> dataModel) {
        if (dataModel == null) {
            throw new NullPointerException("Data model cannot be null.");
        }
        WizardDisplayModelItem.ProtectedMap protectedModel = new WizardDisplayModelItem.ProtectedMap(dataModel, false, this);
        return this.getState(protectedModel);
    }

    public UpdateResultDTO touchCompleteModel(Map<String, ModelItemDTO> dataModel) {
        List<LogicModelItem> toplevelItems = this.modelRoot.getLogicModel().getTopLevelItems();
        Map<String, ModelItemDTO> touchValues = this.expertUpdatePreprocessor.touchModelItems("", toplevelItems, dataModel);
        UpdateResultDTO result = this.update(dataModel, touchValues, true);
        ExpertDisplayModel.ProtectedMap pMap = new ExpertDisplayModel.ProtectedMap(dataModel, false, this);
        ExpertDisplayInfoDTO edi = this.modelRoot.getExpertDisplayModel().getExpertDisplayInfo(pMap, null, this.logicModelItems, null, 1);
        result.setExpertDisplayInfoDTO(edi);
        result.getPersistenceWriteDTOs().putAll(pMap.getChangedMap());
        return result;
    }

    public UpdateResultDTO touchCompleteModel(Map<String, ModelItemDTO> dataModel, DvbTaxSessionWorkStatus status) throws InterruptedException {
        List<LogicModelItem> toplevelItems = this.modelRoot.getLogicModel().getTopLevelItems();
        Map<String, ModelItemDTO> touchValues = this.expertUpdatePreprocessor.touchModelItems("", toplevelItems, dataModel);
        UpdateResultDTO result = this.update(dataModel, touchValues, true, status);
        ExpertDisplayModel.ProtectedMap pMap = new ExpertDisplayModel.ProtectedMap(dataModel, false, this);
        ExpertDisplayInfoDTO edi = this.modelRoot.getExpertDisplayModel().getExpertDisplayInfo(pMap, null, this.logicModelItems, null, 1);
        result.setExpertDisplayInfoDTO(edi);
        result.getPersistenceWriteDTOs().putAll(pMap.getChangedMap());
        return result;
    }

    private int getState(WizardDisplayModelItem.ProtectedMap dataModel) {
        int state = 1;
        List<Module> topLevelModuls = this.modelRoot.getLogicModel().getModuls();
        for (Module module : topLevelModuls) {
            String dmk;
            ModelItemDTO dto;
            if (!module.isImportantState() || (dto = dataModel.getWithoutTouch(dmk = module.getName())) == null || !dto.hasMoreImportantState(state) || dto.getState() == 12 || dto.getState() == 11) continue;
            state = dto.getState();
        }
        return state;
    }

    public UpdateResultDTO recalculate(Map<String, ModelItemDTO> dataModel) {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, true);
        dataModelMap.setRecalculating(true);
        HashMap<String, ModelItemDTO> input = new HashMap<String, ModelItemDTO>();
        input.putAll(dataModel);
        long dmkValidationTime = 0L;
        for (Map.Entry me : input.entrySet()) {
            String dataModelKey = (String)me.getKey();
            String logicModelKey = EngineUtil.removeTableIndices(dataModelKey);
            LogicModelItem lmi = this.logicModelItems.get(logicModelKey);
            if (lmi == null) {
                LOG.debug("invalid model item key: " + logicModelKey + " not found");
                dataModel.remove(dataModelKey);
                continue;
            }
            long time = System.currentTimeMillis();
            boolean isDmkValid = Engine.checkDataModelKey(dataModel, dataModelKey);
            time = System.currentTimeMillis() - time;
            dmkValidationTime += time;
            if (!isDmkValid) {
                dataModel.remove(dataModelKey);
                continue;
            }
            ModelItemDTO currentValue = dataModelMap.get(dataModelKey);
            ModelItemDTO oldValue = (ModelItemDTO)me.getValue();
            if (currentValue == null || !currentValue.equals(oldValue)) continue;
            lmi.fireDataChangedEvent(dataModelMap, dataModelKey, null, null, null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("dataModelKey validation took " + dmkValidationTime + "ms");
        }
        this.processAsyncUpdates(dataModelMap);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    public UpdateResultDTO recalculate(Map<String, ModelItemDTO> dataModel, DvbTaxSessionWorkStatus dvbTaxSessionWorkStatus) throws InterruptedException {
        LogicModelItem.ProtectedMap dataModelMap = new LogicModelItem.ProtectedMap(dataModel, true);
        dataModelMap.setRecalculating(true);
        HashMap<String, ModelItemDTO> input = new HashMap<String, ModelItemDTO>();
        input.putAll(dataModel);
        long dmkValidationTime = 0L;
        int counter = 0;
        int totalValuesCount = dataModel.size();
        dvbTaxSessionWorkStatus.setWorkPercentageDone(0);
        long startTime = System.currentTimeMillis();
        double oneRunTime = 0.0;
        for (Map.Entry me : input.entrySet()) {
            long tmp;
            String dataModelKey = (String)me.getKey();
            String logicModelKey = EngineUtil.removeTableIndices(dataModelKey);
            LogicModelItem lmi = this.logicModelItems.get(logicModelKey);
            if (lmi == null) {
                LOG.debug("invalid model item key: " + logicModelKey + " not found");
                dataModel.remove(dataModelKey);
            } else {
                long time = System.currentTimeMillis();
                boolean isDmkValid = Engine.checkDataModelKey(dataModel, dataModelKey);
                time = System.currentTimeMillis() - time;
                dmkValidationTime += time;
                if (!isDmkValid) {
                    dataModel.remove(dataModelKey);
                } else {
                    ModelItemDTO currentValue = dataModelMap.get(dataModelKey);
                    ModelItemDTO oldValue = (ModelItemDTO)me.getValue();
                    if (currentValue != null && currentValue.equals(oldValue)) {
                        lmi.fireDataChangedEvent(dataModelMap, dataModelKey, null, null, null);
                    }
                }
            }
            if (oneRunTime == 0.0) {
                oneRunTime = System.currentTimeMillis() - startTime;
                if (oneRunTime > 0.0 && counter > 0) {
                    oneRunTime /= (double)counter;
                }
            } else if (counter % 1000 == 0 && ((tmp = System.currentTimeMillis()) - startTime) / (long)counter > 0L) {
                oneRunTime = (double)(tmp - startTime) / (double)counter;
            }
            int percentage = 100 * counter++ / totalValuesCount;
            long timeLeft = Math.round((double)(totalValuesCount - counter) * oneRunTime / 1000.0);
            dvbTaxSessionWorkStatus.setTimeRemaining(Long.valueOf(timeLeft).intValue());
            dvbTaxSessionWorkStatus.setWorkPercentageDone(percentage);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("dataModelKey validation took " + dmkValidationTime + "ms");
        }
        this.processAsyncUpdates(dataModelMap);
        dvbTaxSessionWorkStatus.setWorkPercentageDone(100);
        return new UpdateResultDTO(dataModelMap.getChangedMap(), dataModelMap.getUndoInfoMap(), dataModelMap.getDeleteWarnings(), dataModelMap.getTableUpdates());
    }

    private static boolean checkDataModelKey(Map<String, ModelItemDTO> dataModel, String dataModelKey) {
        boolean isInTable;
        boolean bl = isInTable = !EngineUtil.removeTableIndices(dataModelKey).equals(dataModelKey);
        if (!isInTable) {
            return true;
        }
        String key = dataModelKey;
        while (!key.isEmpty()) {
            if (EngineUtil.endsWithTableIndex(key)) {
                String index = EngineUtil.getLastKeyPart(key);
                Set tableEntries = Collections.emptySet();
                String tableKey = EngineUtil.removeLastKeyPart(key);
                ModelItemDTO mi = dataModel.get(tableKey);
                if (mi != null && mi.getValue() != null) {
                    Set value;
                    tableEntries = value = (Set)mi.getValue();
                }
                if (!tableEntries.contains(index)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("dataModelKey form no exisiting table enty. deleting item : " + dataModelKey);
                    }
                    return false;
                }
            }
            key = EngineUtil.removeLastKeyPart(key);
        }
        return true;
    }

    public Barcode2DDataDTO generateBarcode(Map<String, ModelItemDTO> dataModel, Barcode2DGenerator generator, List barcodeLines) {
        if (dataModel == null) {
            throw new NullPointerException("dataModel may not be null");
        }
        if (generator == null) {
            throw new NullPointerException("generator may not be null");
        }
        ExpertDisplayModel.ProtectedMap dataModelMap = new ExpertDisplayModel.ProtectedMap(dataModel, true, this);
        ExpertDisplayModel.RequestContext ctx = new ExpertDisplayModel.RequestContext(dataModelMap, null, null, null, null, null, null, this.logicModelItems);
        ctx.setBarcodeLines(barcodeLines);
        Barcode2DDataDTO barcode = new Barcode2DDataDTO(generator.generateData(ctx), generator.generateId(ctx), generator.getContentType());
        return barcode;
    }

    public Map<String, LogicModelItem> getLogicModel() {
        return this.logicModelItems;
    }

    public Map<String, LogicModelItemInfoDTO> getLogicModelItemsInfo() {
        return this.logicModelItemsInfo;
    }

    public void visit(@NonNull LogicModelVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("Model visitor cannot be null.");
        }
        this.modelRoot.getLogicModel().visit(visitor);
    }

    public void visit(@NonNull WizardModelVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("Model visitor cannot be null.");
        }
        this.modelRoot.getWizardDisplayModel().visit(visitor);
    }

    public void visit(@NonNull ExpertModelVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("Model visitor cannot be null.");
        }
        this.modelRoot.getExpertDisplayModel().visit(visitor);
    }

    private static class CustomResourceLocator
    implements ResourceLocator {
        private final String xmlStructure;

        public CustomResourceLocator(String xmlStructure) {
            this.xmlStructure = xmlStructure;
        }

        public void addResourceChangeListener(@NonNull ResourceChangeListener arg0) {
        }

        public @NonNull InputStream getResourceAsStream(@NonNull String arg0) throws ResourceNotFoundException {
            if (this.xmlStructure == null || this.xmlStructure.isEmpty()) {
                throw new ResourceNotFoundException("missing xml model");
            }
            return new ByteArrayInputStream(this.xmlStructure.getBytes());
        }

        public void removeResourceChangeListener(@NonNull ResourceChangeListener arg0) {
        }
    }

    public static class WizardDisplayInfoDTOAndChanges {
        private final WizardDisplayInfoDTO wizardDisplayInfoDTO;
        private final Map<String, List<PersistenceWriteDTO>> changes;
        private final Map<String, ModelItemDTO> undoInformations;

        public WizardDisplayInfoDTOAndChanges(WizardDisplayInfoDTO wizardDisplayInfoDTO, Map<String, List<PersistenceWriteDTO>> changes, Map<String, ModelItemDTO> undoInformations) {
            this.wizardDisplayInfoDTO = wizardDisplayInfoDTO;
            this.changes = changes;
            this.undoInformations = undoInformations;
        }

        public Map<String, List<PersistenceWriteDTO>> getChanges() {
            return this.changes;
        }

        public WizardDisplayInfoDTO getWizardDisplayInfoDTO() {
            return this.wizardDisplayInfoDTO;
        }

        public Map<String, ModelItemDTO> getUndoInformations() {
            return this.undoInformations;
        }
    }

    public static class ExpertDisplayInfoDTOAndChanges {
        private final ExpertDisplayInfoDTO expertDisplayInfoDTO;
        private final Map<String, List<PersistenceWriteDTO>> changes;

        public ExpertDisplayInfoDTOAndChanges(ExpertDisplayInfoDTO expertDisplayInfoDTO, Map<String, List<PersistenceWriteDTO>> changes) {
            this.expertDisplayInfoDTO = expertDisplayInfoDTO;
            this.changes = changes;
        }

        public Map<String, List<PersistenceWriteDTO>> getChanges() {
            return this.changes;
        }

        public ExpertDisplayInfoDTO getExpertDisplayInfoDTO() {
            return this.expertDisplayInfoDTO;
        }
    }

    public static class ChangesAndUndoInformations {
        private final Map<String, List<PersistenceWriteDTO>> changes;
        private final Map<String, ModelItemDTO> undoInformations;

        public ChangesAndUndoInformations(Map<String, List<PersistenceWriteDTO>> changes, Map<String, ModelItemDTO> undoInformations) {
            this.changes = changes;
            this.undoInformations = undoInformations;
        }

        public Map<String, List<PersistenceWriteDTO>> getChanges() {
            return this.changes;
        }

        public Map<String, ModelItemDTO> getUndoInformations() {
            return this.undoInformations;
        }
    }
}

