/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8802405016599916881L;
    private final @NonNull String fileId;
    private final @NonNull String fileName;
    private final long fileSize;
    private final @NonNull String mimeType;
    private @Nullable byte[] fileData;

    public FileData(@NonNull String fileId, @NonNull String fileName, long fileSize, @NonNull String mimeType, @Nullable byte[] fileData) {
        this.fileId = Objects.requireNonNull(fileId);
        this.fileName = (String)Validate.notBlank((CharSequence)fileName);
        Validate.isTrue((fileSize > 0L ? 1 : 0) != 0, (String)"filesize must be > 0", (long)fileSize);
        this.fileSize = fileSize;
        this.mimeType = (String)Validate.notBlank((CharSequence)mimeType, (String)"mimeType must not be blank", (Object[])new Object[0]);
        this.fileData = fileData;
    }

    public FileData(@NonNull String fileId, @NonNull String fileName, long fileSize, @NonNull String mimeType) {
        this(fileId, fileName, fileSize, mimeType, null);
    }

    public FileData(@NonNull FileData orig) {
        this(orig.fileId, orig.fileName, orig.fileSize, orig.mimeType, orig.fileData != null ? (byte[])orig.fileData.clone() : null);
    }

    public FileData(@NonNull FileData orig, @Nullable byte[] fileData) {
        this(orig.fileId, orig.fileName, orig.fileSize, orig.mimeType, fileData);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fileId", (Object)this.fileId).append("fileName", (Object)this.fileName).append("fileSize", this.fileSize).append("mimeType", (Object)this.mimeType).append("fileData", this.fileData == null ? "null" : "[bytes: " + this.fileData.length + "]").toString();
    }

    public FileData clone() {
        return new FileData(this);
    }

    public @NonNull String getFileId() {
        return this.fileId;
    }

    public @NonNull String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public @NonNull String getMimeType() {
        return this.mimeType;
    }

    public @Nullable byte[] getFileData() {
        return this.fileData;
    }

    public void setFileData(byte[] fileData) {
        this.fileData = fileData;
    }

    public void clearFileData() {
        this.fileData = null;
    }
}

