/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Table;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LMK
implements Serializable,
Comparable<LMK> {
    private static final long serialVersionUID = -1738340904209186520L;
    public static final String PART_SEPARATOR = ".";
    private static final String SEPARATOR_SPLITTER = "\\.";
    private static final Pattern LMK_PART_PATTERN = Pattern.compile("^\\p{Alpha}\\w*$");
    private static final Pattern LMK_PATTERN = Pattern.compile("^\\p{Alpha}\\w*(\\.\\p{Alpha}\\w*)*$");
    private final @NonNull String externalForm;
    private final @NonNull String[] parts;

    public LMK(@NonNull String lmk) {
        Objects.requireNonNull(lmk);
        if (!LMK_PATTERN.matcher(lmk).matches()) {
            throw new IllegalArgumentException("Not a valid LMK: >" + lmk + "<");
        }
        this.externalForm = lmk;
        this.parts = lmk.split(SEPARATOR_SPLITTER);
    }

    private LMK(@NonNull String[] parts) {
        this.externalForm = LMK.toExternalForm(Objects.requireNonNull(parts));
        this.parts = Objects.requireNonNull(parts);
    }

    public static @Nullable LMK parse(@Nullable String lmk) {
        if (lmk == null) {
            return null;
        }
        return new LMK(lmk);
    }

    public static @NonNull LMK fromLogicModelItem(@NonNull LogicModelItem lmi) {
        return LMK.parse(lmi.getName());
    }

    @NonNull String[] getParts() {
        return Arrays.copyOf(this.parts, this.parts.length);
    }

    public static @NonNull String toExternalForm(@NonNull String[] parts) {
        return StringUtils.join((Object[])parts, (String)PART_SEPARATOR);
    }

    public @NonNull String toExternalForm() {
        return this.externalForm;
    }

    public @NonNull String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.externalForm).build();
    }

    private static boolean partsMatch(@NonNull String[] thisParts, String[] otherParts, int depth) {
        if (depth <= 0) {
            return true;
        }
        if (thisParts.length < depth || otherParts.length < depth) {
            return false;
        }
        for (int i = 0; i < depth; ++i) {
            if (thisParts[i].equals(otherParts[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(@NonNull LMK lmk) {
        return this.externalForm.compareTo(lmk.externalForm);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LMK other = (LMK)obj;
        return this.externalForm.equals(other.externalForm);
    }

    public int hashCode() {
        return this.externalForm.hashCode();
    }

    public boolean contains(@NonNull LMK other) {
        return other.parts.length > this.parts.length && LMK.partsMatch(this.parts, other.parts, this.parts.length);
    }

    public boolean sameParent(@NonNull LMK other) {
        return this.parts.length == other.parts.length && LMK.partsMatch(this.parts, other.parts, this.parts.length - 1);
    }

    public @NonNull LMK append(@NonNull String part) {
        if (!LMK_PART_PATTERN.matcher(part).matches()) {
            throw new IllegalArgumentException("Not a valid LMK part: " + part + " (LMK: " + this.toExternalForm() + ")");
        }
        return new LMK(this.externalForm + PART_SEPARATOR + part);
    }

    public boolean isToplevel() {
        return this.parts.length == 1;
    }

    public LMK getParent() {
        if (this.isToplevel()) {
            throw new IllegalStateException("Cannot get parent of root");
        }
        String[] parentParts = Arrays.copyOf(this.parts, this.parts.length - 1);
        return new LMK(parentParts);
    }

    public @NonNull Optional<Table> findContainingTable(@NonNull Map<String, LogicModelItem> logicModel) {
        LogicModelItem lmi = logicModel.get(this.toExternalForm());
        return lmi.findContainingTable();
    }

    public @NonNull DMK toRootlevelDMK() {
        return DMK.parse(this.toExternalForm());
    }
}

