/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModel;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModel;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ModelRoot {
    private String name = null;
    private LogicModel logicModel = null;
    private WizardDisplayModel wizardDisplayModel = null;
    private ExpertDisplayModel expertDisplayModel = null;

    public ModelRoot(String name, LogicModel logicModel, WizardDisplayModel wizardDisplayModel, ExpertDisplayModel expertDisplayModel) {
        this.name = name;
        this.logicModel = logicModel;
        this.wizardDisplayModel = wizardDisplayModel;
        this.expertDisplayModel = expertDisplayModel;
    }

    public String getName() {
        return this.name;
    }

    public LogicModel getLogicModel() {
        return this.logicModel;
    }

    public WizardDisplayModel getWizardDisplayModel() {
        return this.wizardDisplayModel;
    }

    public ExpertDisplayModel getExpertDisplayModel() {
        return this.expertDisplayModel;
    }

    public void initializeLogicModel(Map<String, LogicModelItem> logicModelItems, List<PersistenceReadDTO> persistenceReadDTOs, boolean verbose) throws InvalidModelException {
        if (this.name == null || this.name.isEmpty()) {
            throw new InvalidModelException("No name specified for TMO model!");
        }
        this.logicModel.initializeLogicModel(logicModelItems, persistenceReadDTOs, verbose);
    }

    public void initializeReferences(Map<String, LogicModelItem> lm) throws InvalidModelException {
        this.logicModel.initializeReferences(lm);
    }

    public void initializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems, Map<String, Form> wizardDisplayModelItems) throws InvalidModelException {
        this.wizardDisplayModel.initializeWizardDisplayModel(logicModelItems, wizardDisplayModelItems);
    }

    public void initializeExpertDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        this.expertDisplayModel.initializeExpertDisplayModel(logicModelItems);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            LogicModel logicModel = null;
            WizardDisplayModel wizardDisplayModel = null;
            ExpertDisplayModel expertDisplayModel = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof LogicModel) {
                        logicModel = (LogicModel)ref;
                        continue;
                    }
                    if (ref instanceof WizardDisplayModel) {
                        wizardDisplayModel = (WizardDisplayModel)ref;
                        continue;
                    }
                    if (ref instanceof ExpertDisplayModel) {
                        expertDisplayModel = (ExpertDisplayModel)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            return new ClassObjectPair(ModelRoot.class, (Object)new ModelRoot(element.getAttributeValue("name"), logicModel, wizardDisplayModel, expertDisplayModel));
        }
    }
}

