/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Coalesce
implements CalcItem {
    public static final int MIN_STACK_ELEMENTS_COUNT = 2;
    private final int count;

    public Coalesce(int count) {
        assert (count >= 2);
        this.count = count;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        int i;
        if (stack.size() < this.count) {
            throw new IllegalArgumentException("Too few arguments on the Stack: " + stack.size() + " von " + this.count);
        }
        Object value = null;
        Object[] stackValues = new Object[this.count];
        for (i = 0; i < this.count; ++i) {
            stackValues[i] = stack.pop();
        }
        for (i = this.count - 1; i >= 0; --i) {
            if (value != null) continue;
            value = stackValues[i];
        }
        stack.push(value);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            int count = 2;
            String countText = element.getAttributeValue("count");
            if (countText != null && !"".equals(countText)) {
                count = Integer.valueOf(countText, 10);
                assert (count >= 2);
            }
            Coalesce result = new Coalesce(count);
            return new ClassObjectPair(Coalesce.class, (Object)result);
        }
    }
}

