/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constant
implements ComplexCalcItem {
    private static final Logger LOG = LoggerFactory.getLogger(Constant.class);
    private final @Nullable Object value;
    private final @Nullable String key;
    private final @NonNull Class<?> clazz;
    private final @NonNull DataResource dataResource;
    private final @Nullable Reference absRef1;
    private static final DataResource FAIL_DATA_RESOURCE = new DataResource(){

        @Override
        public @NonNull Map<?, ?> get(@NonNull String code, @Nullable Object arg1, @Nullable Object arg2) {
            throw new NotImplementedException("FailDataResource called: " + code + "/" + String.valueOf(arg1) + "/" + String.valueOf(arg2));
        }
    };

    public Constant(@Nullable Object value, @Nullable String key, @NonNull Class<?> clazz, @Nullable DataResource dataResource, @Nullable Reference absRef1) {
        if (value == null == (key == null)) {
            throw new IllegalArgumentException("Must give either value or key, actual: " + String.valueOf(value) + "/" + key);
        }
        this.value = value;
        this.key = key;
        this.clazz = Objects.requireNonNull(clazz);
        if (key != null && dataResource == null) {
            throw new IllegalArgumentException("Key requires a dataResource");
        }
        this.dataResource = dataResource != null ? dataResource : FAIL_DATA_RESOURCE;
        this.absRef1 = absRef1;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        if (this.absRef1 != null) {
            this.absRef1.registerListenerOnReference(logicModel, logicModelItem, false);
        }
    }

    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Object newValue = this.key != null ? this.evaluateByKey(model, stack, dataModelKey) : this.value;
        stack.push(newValue);
    }

    private @Nullable Object evaluateByKey(@NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Object arg1 = null;
        if (this.absRef1 != null) {
            ModelItemDTO arg1Item = model.get(EngineUtil.mergeModelKey(this.absRef1.getName(), dataModelKey));
            arg1 = arg1Item != null ? arg1Item.getValue() : null;
        }
        Map<?, ?> constantMap = this.dataResource.get("constants", arg1, null);
        Map<?, ?> map = Objects.requireNonNull(constantMap, "Could not find constant value for: " + this.key + "/" + String.valueOf(arg1));
        String sValue = (String)constantMap.get(this.key);
        if (sValue == null) {
            LOG.error("key {} not found in constants.txt with arg: {}", (Object)this.key, arg1);
            return null;
        }
        try {
            Constructor<?> constructor = this.clazz.getConstructor(String.class);
            Object valueByKey = constructor.newInstance(sValue);
            return valueByKey;
        }
        catch (Exception t) {
            LOG.error("could not convert constant-value {} to given class {}", new Object[]{sValue, this.clazz, t});
            return null;
        }
    }

    public static class XMLFactory
    implements ElementParser {
        private final @Nullable DataResource dataResource;

        public XMLFactory(@Nullable DataResource dataResource) {
            this.dataResource = dataResource;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Class clazz;
            String sValue = element.getAttributeValue("value");
            String sKey = element.getAttributeValue("key");
            if (sValue == null && sKey == null || sValue != null && sKey != null) {
                throw new ElementParserException("either value or key must be specified, concerns CalcItem " + Objects.requireNonNull(element.getParent()).getAttributeValue("name"));
            }
            if (element.getAttributeValue("class") != null) {
                try {
                    clazz = Class.forName(element.getAttributeValue("class"));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ElementParserException((Throwable)cnfe);
                }
            } else {
                clazz = sValue == null || sValue.indexOf(46) == -1 ? Long.class : Double.class;
            }
            DataResource ds = null;
            Date value = null;
            if (sKey != null) {
                ds = this.dataResource;
            } else {
                try {
                    if (Date.class.equals(clazz)) {
                        SimpleDateFormat sdf = new SimpleDateFormat("DD.mm.yyyy", Locale.GERMAN);
                        sdf.setTimeZone(ApplicationConfig.TIMEZONE);
                        value = sdf.parse(sValue);
                    } else {
                        Constructor constructor = clazz.getConstructor(String.class);
                        value = constructor.newInstance(sValue);
                    }
                }
                catch (Exception t) {
                    throw new ElementParserException((Throwable)t);
                }
            }
            String absRef1Str = element.getAttributeValue("absRef1");
            Reference absRef1 = null;
            if (absRef1Str != null) {
                absRef1 = new Reference(absRef1Str, false);
            }
            return new ClassObjectPair(Constant.class, (Object)new Constant(value, sKey, clazz, ds, absRef1));
        }
    }
}

