/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CutCopy
implements CalcItem {
    private final String name;
    private boolean isCut = false;

    private CutCopy(String name, boolean isCut) {
        this.name = name;
        this.isCut = isCut;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelItemKey) {
        Object value = stack.isEmpty() ? null : (this.isCut ? stack.pop() : stack.peek());
        dataModel.getClipboard().put(this.name, value);
    }

    public static class XMLFactory
    implements ElementParser {
        private final boolean isCut;

        public XMLFactory(boolean isCut) {
            this.isCut = isCut;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String name = element.getAttributeValue("name");
            if (name == null) {
                name = "default";
            }
            return new ClassObjectPair(CutCopy.class, (Object)new CutCopy(name, this.isCut));
        }
    }
}

