/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class EqualsNullAsZero
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("EqualsNullAsZero needs 2 elements on stack");
        }
        Object value1 = stack.pop();
        Object value2 = stack.pop();
        if (value1 == null && value2 instanceof Number) {
            stack.push(((Number)value2).longValue() == 0L);
        } else if (value2 == null && value1 instanceof Number) {
            stack.push(((Number)value1).longValue() == 0L);
        } else if (value1 instanceof Long && value2 instanceof Long) {
            stack.push(value1.equals(value2));
        } else if (value1 instanceof Number && value2 instanceof Number) {
            boolean b = Math.abs(((Number)value2).doubleValue() - ((Number)value1).doubleValue()) < 1.0E-8;
            stack.push(b);
        } else if (value1 == null && value2 == null) {
            stack.push(Boolean.TRUE);
        } else if (value1 != null) {
            stack.push(value1.equals(value2));
        } else {
            stack.push(Boolean.FALSE);
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            EqualsNullAsZero result = new EqualsNullAsZero();
            return new ClassObjectPair(EqualsNullAsZero.class, (Object)result);
        }
    }
}

