/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Floor
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Floor needs 1 element on stack");
        }
        Object value = stack.pop();
        if (value == null) {
            stack.push(null);
        } else if (value instanceof Number) {
            stack.push(Math.floor(((Number)value).doubleValue()));
        } else {
            throw new IllegalArgumentException("Floor must be invoked on a Number");
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Floor result = new Floor();
            return new ClassObjectPair(Floor.class, (Object)result);
        }
    }
}

