/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.calcitems.AbstractCompare;
import ch.dvbern.tax.common.engine.util.CompareUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.qual.NonNull;

public class InRange
extends AbstractCompare {
    private static final Integer ZERO = 0;
    private final Object lowerLimit;
    private final boolean lowerLimitInclusive;
    private final Object upperLimit;
    private final boolean upperLimitInclusive;
    private final boolean lhsNullAsZero;

    public InRange(Object lowerLimit, boolean lowerLimitInclusive, Object upperLimit, boolean upperLimitInclusive, boolean lhsNullAsZero) {
        super(false);
        this.lowerLimit = lowerLimit;
        this.lowerLimitInclusive = lowerLimitInclusive;
        this.upperLimit = upperLimit;
        this.upperLimitInclusive = upperLimitInclusive;
        this.lhsNullAsZero = lhsNullAsZero;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Boolean inLowerLimit;
        Object lowerRhs = this.lowerLimit != null ? this.lowerLimit : stack.pop();
        Object upperRhs = this.upperLimit != null ? this.upperLimit : stack.pop();
        Object lhs = stack.pop();
        if (lowerRhs == null || upperRhs == null) {
            stack.push(null);
            return;
        }
        if (!this.compare(CompareUtil.Operator.SMALLER_OR_EQUAL, lowerRhs, upperRhs).booleanValue()) {
            throw new IllegalArgumentException("Lower limit must always be smaller or equal to the upper limit.");
        }
        if (lhs == null) {
            if (this.lhsNullAsZero) {
                lhs = ZERO;
            } else {
                stack.push(null);
                return;
            }
        }
        if ((inLowerLimit = this.compare(this.lowerLimitInclusive ? CompareUtil.Operator.GREATER_OR_EQUAL : CompareUtil.Operator.GREATER, lhs, lowerRhs)) == null) {
            stack.push(null);
            return;
        }
        Boolean inUpperLimit = this.compare(this.upperLimitInclusive ? CompareUtil.Operator.SMALLER_OR_EQUAL : CompareUtil.Operator.SMALLER, lhs, upperRhs);
        if (inUpperLimit == null) {
            stack.push(null);
            return;
        }
        stack.push(inLowerLimit != false && inUpperLimit != false);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            String nullAsZeroStr = element.getAttribute("nullAsZero");
            boolean nullAsZero = nullAsZeroStr != null ? Boolean.valueOf(nullAsZeroStr) : false;
            BigDecimal from = this.parseLimit(element, "from");
            BigDecimal to = this.parseLimit(element, "to");
            boolean fromInclusive = this.parseInclusive(element, "from-incl");
            boolean toInclusive = this.parseInclusive(element, "to-incl");
            return new ClassObjectPair(InRange.class, (Object)new InRange(from, fromInclusive, to, toInclusive, nullAsZero));
        }

        private boolean parseInclusive(Element element, String name) {
            assert (element != null && name != null);
            String inclStr = element.getAttribute(name);
            if (inclStr != null) {
                return Boolean.valueOf(inclStr);
            }
            return true;
        }

        private BigDecimal parseLimit(Element element, String name) throws ElementParserException {
            BigDecimal limit;
            assert (element != null && name != null);
            String limitStr = element.getAttribute(name);
            if (limitStr != null) {
                try {
                    limit = new BigDecimal(limitStr);
                }
                catch (NumberFormatException e) {
                    throw new ElementParserException("Attribute \"" + name + "\" must be a valid number", (Throwable)e);
                }
            } else {
                limit = null;
            }
            return limit;
        }
    }
}

