/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.text.DecimalFormat;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Length
implements CalcItem {
    private DecimalFormat longFormat = new DecimalFormat("0");
    private DecimalFormat doubleFormat = new DecimalFormat("0.0");

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        int result = 0;
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Length needs 1 element on stack");
        }
        Object value = stack.pop();
        if (value instanceof Number) {
            if (value instanceof Long) {
                Long l = (Long)value;
                result = this.longFormat.format(l).length();
            } else {
                Number n = (Number)value;
                result = this.doubleFormat.format(n.doubleValue()).length();
            }
        } else if (value != null) {
            result = value.toString().length();
        }
        stack.push(result);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Length result = new Length();
            return new ClassObjectPair(Length.class, (Object)result);
        }
    }
}

