/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.calcitems.AbstractCompare;
import ch.dvbern.tax.common.engine.util.CompareUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MinOrMaxValue
extends AbstractCompare {
    private final NullHandling nullHandling;
    private final Mode mode;
    private final Object rhs;
    private final boolean greedy;

    public MinOrMaxValue(Mode mode, Object rhs, NullHandling nullHandling, boolean greedy) {
        super(nullHandling == NullHandling.NULL_AS_ZERO);
        if (mode == null) {
            throw new NullPointerException("Comparison mode cannot be null.");
        }
        if (nullHandling == null) {
            throw new NullPointerException("Null-handling strategy cannot be null.");
        }
        this.nullHandling = nullHandling;
        this.mode = mode;
        this.rhs = rhs;
        this.greedy = greedy;
    }

    private Object compare(Mode mode, Object lhs, Object rhs) {
        CompareUtil.Operator op = mode == Mode.MAX ? CompareUtil.Operator.GREATER : CompareUtil.Operator.SMALLER;
        Boolean cmpOutcome = this.compare(op, lhs, rhs);
        if (cmpOutcome == null) {
            return null;
        }
        return cmpOutcome != false ? lhs : rhs;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Object rhs = this.rhs != null ? this.rhs : stack.pop();
        do {
            Object lhs = stack.pop();
            if (rhs == null && this.nullHandling == NullHandling.IGNORE) {
                rhs = lhs;
                continue;
            }
            if (lhs == null && this.nullHandling == NullHandling.IGNORE) continue;
            rhs = this.compare(this.mode, lhs, rhs);
        } while (this.greedy && !stack.isEmpty());
        if (this.nullHandling == NullHandling.NULL_AS_ZERO && rhs == null) {
            rhs = 0L;
        }
        stack.push(rhs);
    }

    public static enum NullHandling {
        DEFAULT,
        NULL_AS_ZERO,
        IGNORE;

    }

    public static enum Mode {
        MAX,
        MIN;

    }

    public static class XMLFactory
    implements ElementParser {
        private final Mode mode;
        private final NullHandling nullHandling;
        private final Object rhs;
        private final boolean greedy;

        public XMLFactory(@NonNull Mode mode, @Nullable Object rhs, @NonNull NullHandling nullHandling, boolean greedy) {
            if (mode == null) {
                throw new NullPointerException("Comparison mode cannot be null.");
            }
            if (nullHandling == null) {
                throw new NullPointerException("Null-handling strategy cannot be null.");
            }
            this.mode = mode;
            this.rhs = rhs;
            this.nullHandling = nullHandling;
            this.greedy = greedy;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory parserFactory) throws ElementParserException {
            return new ClassObjectPair(MinOrMaxValue.class, (Object)new MinOrMaxValue(this.mode, this.rhs, this.nullHandling, this.greedy));
        }
    }
}

