/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Multiply
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Multiply needs 2 elements on stack");
        }
        Object value1 = stack.pop();
        Object value2 = stack.pop();
        if (value1 == null && value2 == null) {
            stack.push(null);
            return;
        }
        if (value1 == null || value1.toString().isEmpty()) {
            value1 = 0L;
        }
        if (value2 == null || value2.toString().isEmpty()) {
            value2 = 0L;
        }
        if (value1 instanceof Long && value2 instanceof Long) {
            long l = (Long)value2 * (Long)value1;
            stack.push(l);
        } else if (value1 instanceof Number && value2 instanceof Number) {
            double d = ((Number)value2).doubleValue() * ((Number)value1).doubleValue();
            stack.push(d);
        } else {
            throw new IllegalArgumentException("Both arguments of Multiply need to be of the type Number");
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Multiply result = new Multiply();
            return new ClassObjectPair(Multiply.class, (Object)result);
        }
    }
}

