/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RoundFiveCents
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 1) {
            throw new IllegalArgumentException("RoundFiveCents needs 1 element on stack");
        }
        Object value = stack.pop();
        if (value == null) {
            stack.push(null);
            return;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Argument of RoundFiveCents must be of type Number");
        }
        if (value instanceof Double || value instanceof Float) {
            double d = Math.round(((Number)value).doubleValue() * 20.0);
            value = d / 20.0;
        }
        stack.push(value);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            RoundFiveCents result = new RoundFiveCents();
            return new ClassObjectPair(RoundFiveCents.class, (Object)result);
        }
    }
}

