/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Summe
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        double result = 0.0;
        boolean isNull = true;
        boolean flagFloat = false;
        while (!stack.isEmpty()) {
            Object o = stack.pop();
            if (o == null) continue;
            if (!flagFloat && o instanceof Long) {
                result += (double)((Long)o).longValue();
                isNull = false;
                continue;
            }
            if (o instanceof Number) {
                if (o instanceof Double) {
                    flagFloat = true;
                }
                result += ((Number)o).doubleValue();
                isNull = false;
                continue;
            }
            throw new IllegalArgumentException("All arguments of Summe need to be of type Number");
        }
        if (isNull) {
            stack.push(null);
        } else if (flagFloat) {
            stack.push(result);
        } else {
            stack.push((long)result);
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Summe result = new Summe();
            return new ClassObjectPair(Summe.class, (Object)result);
        }
    }
}

