/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Barcode1DItem
extends ExpertFormDisplayModelItem {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int barHeight;
    private final int textSize;
    private final int type;
    private final float minBarWidth;
    private final float relBarWidth;
    private final String logicModelItemName;
    private LogicModelItem logicModelItem;
    private final ColorDTO bgColor;

    public Barcode1DItem(int x, int y, int width, int height, ColorDTO bgColor, int barHeight, float minBarWidth, float relBarWidth, int textSize, int type, String logicModelItemName, int printMode, Set<String> languages) {
        super(languages, printMode, false);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.bgColor = bgColor;
        this.barHeight = barHeight;
        this.minBarWidth = minBarWidth;
        this.relBarWidth = relBarWidth;
        this.textSize = textSize;
        this.type = type;
        this.logicModelItemName = logicModelItemName;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, requestContext.getFormAccessKey());
        ModelItemDTO miDTO = requestContext.getDataModel().getWithoutTouch(dmk);
        return new ExpertDisplayInfoDTO.Barcode1DDTO(this.x, this.y, this.width, this.height, this.bgColor, this.barHeight, this.minBarWidth, this.relBarWidth, this.textSize, miDTO, this.type, this.getPrintMode(), this.getUniqueItemIdentifier());
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        this.logicModelItem = logicModelItems.get(this.logicModelItemName);
        if (this.logicModelItem == null) {
            throw new InvalidModelException("invalid item reference (" + this.logicModelItemName + ") in " + this.getClass().getName());
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            int type;
            float barHeigth = ExpertDisplayUtil.getFloat(element.getAttributeValue("barHeight"), -1.0f);
            String typeAttr = element.getAttributeValue("type");
            if (typeAttr == null || typeAttr.isEmpty()) {
                type = 1;
            } else if ("code39".equalsIgnoreCase(typeAttr)) {
                type = 1;
            } else if ("code128".equalsIgnoreCase(typeAttr)) {
                type = 2;
            } else {
                throw new ElementParserException("invalid barcode type: " + typeAttr);
            }
            return new ClassObjectPair(Barcode1DItem.class, (Object)new Barcode1DItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), (int)(barHeigth > 0.0f ? (float)ExpertDisplayUtil.toPixel(barHeigth) : barHeigth), ExpertDisplayUtil.getFloat(element.getAttributeValue("minBarWidth"), -1.0f), ExpertDisplayUtil.getFloat(element.getAttributeValue("relBarWidth"), -1.0f), ExpertDisplayUtil.getInt(element.getAttributeValue("textSize"), -1), type, element.getAttributeValue("value"), ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang"))));
        }
    }
}

