/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem;
import ch.dvbern.tax.common.engine.util.ExpertModelVisitor;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceWriteDTO;
import ch.dvbern.tax.common.transfer.dto.UpdateResultDTO;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpertDisplayModel {
    private final @Nullable Map<String, ExpertFormItem> formItems;
    private final @Nullable List<ExpertNavigationItem> mainNavigationItems;
    private final @NonNull Map<String, ExpertNavigationItem> allNavigationItems = new HashMap<String, ExpertNavigationItem>();

    public ExpertDisplayModel(@Nullable Map<String, ExpertFormItem> formItems, @Nullable List<ExpertNavigationItem> mainNavigationItems) {
        this.formItems = formItems;
        this.mainNavigationItems = mainNavigationItems;
        this.registerAllNavigationItems(mainNavigationItems);
    }

    private void registerAllNavigationItems(@Nullable List<ExpertNavigationItem> navigationItems) {
        if (navigationItems == null || navigationItems.isEmpty()) {
            return;
        }
        Iterator<ExpertNavigationItem> iterator = navigationItems.iterator();
        while (iterator.hasNext()) {
            ExpertNavigationItem element2;
            ExpertNavigationItem element = element2 = iterator.next();
            this.allNavigationItems.put(element.getName(), element);
            this.registerAllNavigationItems(element.getSubItems());
        }
    }

    public void initializeExpertDisplayModel(@NonNull Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.formItems != null) {
            for (ExpertFormItem form : this.formItems.values()) {
                form.initializeExpertDisplayModel(logicModelItems, this.formItems, form.getName());
            }
        }
        if (this.mainNavigationItems != null) {
            for (ExpertNavigationItem navItem : this.mainNavigationItems) {
                navItem.initializeExpertDisplayModel(logicModelItems, this.formItems, "Navigation");
            }
        }
    }

    public @Nullable ExpertDisplayInfoDTO getExpertDisplayInfo(@NonNull ProtectedMap dataModel, @Nullable String key, @NonNull Map<String, LogicModelItem> logicModelItems, @Nullable Locale locale, int mode) {
        ExpertFormItem efi;
        if (this.mainNavigationItems == null) {
            return null;
        }
        String formKey = key;
        if (formKey == null) {
            FastStack tableIndices = new FastStack();
            for (ExpertNavigationItem eni : this.mainNavigationItems) {
                ExpertDisplayInfoDTO.NavigationDTO navDTO = eni.getDTO(dataModel, null, tableIndices, null, true);
                if (navDTO == null || navDTO.getState() == 11 || navDTO.getState() == 12 || navDTO.isExtraForm()) continue;
                formKey = eni.getAccessKey();
                break;
            }
        }
        if (formKey != null && (efi = this.formItems.get(ExpertDisplayUtil.getFormKeyWithoutTableIndizes(formKey))) != null) {
            RequestContext ctx = new RequestContext(dataModel, formKey, efi.getDefaultFont(), efi.getDefaultTableFont(), efi.getDefaultTableHeaderFont(), efi.getDefaultTableTitleFont(), efi.getDefaultTableTitlePattern(), logicModelItems);
            return efi.getDTO(ctx, this.mainNavigationItems, this.allNavigationItems, locale, mode);
        }
        throw new InvalidModelItemKeyException("invalid form access key (" + formKey + ")");
    }

    public @Nullable List<LogicModelItem> getFormStateItems(@NonNull String formAccessKey) {
        ExpertNavigationItem navItem = this.allNavigationItems.get(ExpertDisplayUtil.getFormKeyWithoutTableIndizes(formAccessKey));
        if (navItem != null) {
            return navItem.getStateItems();
        }
        return null;
    }

    public @NonNull List<ExpertDisplayInfoDTO.NavigationDTO> getExpertNavigationItems(ProtectedMap dataModel) {
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> result = new ArrayList<ExpertDisplayInfoDTO.NavigationDTO>();
        if (this.mainNavigationItems != null) {
            for (ExpertNavigationItem eni : this.mainNavigationItems) {
                ExpertDisplayInfoDTO.NavigationDTO dto = eni.getDTO(dataModel, null, new FastStack(), null, true);
                if (dto == null) continue;
                result.add(dto);
            }
        }
        return result;
    }

    public void visit(@NonNull ExpertModelVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("Model visitor cannot be null.");
        }
        if (this.formItems != null) {
            for (ExpertFormItem formItem : this.formItems.values()) {
                this.visit(visitor, formItem);
            }
        }
    }

    private void visit(ExpertModelVisitor visitor, ExpertDisplayModelItem item) {
        visitor.accept(item);
        List<? extends ExpertDisplayModelItem> children = item.getChildren();
        if (children != null) {
            for (ExpertDisplayModelItem expertDisplayModelItem : children) {
                this.visit(visitor, expertDisplayModelItem);
            }
        }
    }

    public static class ProtectedMap
    extends LogicModelItem.ProtectedMap {
        private final @NonNull Engine e;
        private boolean writeOnView;
        private final @NonNull Map<Object, ModelItemDTO> cache = new HashMap<Object, ModelItemDTO>();

        public ProtectedMap(@NonNull Map<String, ModelItemDTO> nestedMap, boolean writeOnView, @NonNull Engine e) {
            super(nestedMap, true);
            this.writeOnView = writeOnView;
            this.e = e;
        }

        public @NonNull ModelItemDTO getModelItem(@NonNull String key) {
            ModelItemDTO modelItemDTO = this.cache.get(key);
            if (modelItemDTO != null) {
                return modelItemDTO;
            }
            modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
                if (this.writeOnView) {
                    this.writeItemInModelOnRead(modelItemDTO, key);
                }
            }
            this.cache.put(key, modelItemDTO);
            return modelItemDTO;
        }

        private void writeItemInModelOnRead(@NonNull ModelItemDTO modelItemDTO, @NonNull String key) {
            HashMap<String, ModelItemDTO> changes = new HashMap<String, ModelItemDTO>();
            changes.put(key, modelItemDTO);
            UpdateResultDTO result = this.e.update(this.nestedMap, changes, true);
            this.getChangedMap().putAll(result.getPersistenceWriteDTOs());
            this.getTableUpdates().putAll(result.getTableUpdates());
        }

        public @NonNull ModelItemDTO getTable(@NonNull String key) {
            Map<String, List<PersistenceWriteDTO>> result;
            HashMap<String, ModelItemDTO> changes;
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(new HashSet(), 1);
                modelItemDTO.setTouched();
                changes = new HashMap();
                changes.put(key, modelItemDTO);
                result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            if (modelItemDTO.getValue() == null || !modelItemDTO.isTouched()) {
                if (!modelItemDTO.isTouched()) {
                    modelItemDTO = modelItemDTO.clone(modelItemDTO.getValue());
                    modelItemDTO.setTouched();
                }
                changes = new HashMap<String, ModelItemDTO>();
                changes.put(key, modelItemDTO);
                result = this.e.update(this.nestedMap, changes, true).getPersistenceWriteDTOs();
                this.getChangedMap().putAll(result);
            }
            return modelItemDTO;
        }

        public @NonNull ModelItemDTO getWithoutTouch(@NonNull String key) {
            ModelItemDTO modelItemDTO = (ModelItemDTO)this.nestedMap.get(key);
            if (modelItemDTO == null) {
                modelItemDTO = new ModelItemDTO(null, 3);
            }
            return modelItemDTO;
        }

        public boolean getWriteOnView() {
            return this.writeOnView;
        }

        public void setWriteOnView(boolean writeOnView) {
            this.writeOnView = writeOnView;
        }
    }

    public static class RequestContext {
        private final @NonNull ProtectedMap dataModel;
        private final @Nullable String formAccessKey;
        private final @Nullable FontDTO defaultFont;
        private final @Nullable FontDTO defaultTableFont;
        private final @Nullable FontDTO defaultTableHeaderFont;
        private final @Nullable FontDTO defaultTableTitleFont;
        private final @Nullable ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern;
        private final @Nullable Map<String, LogicModelItem> logicModelItems;
        private @Nullable List<?> barcodeLines;

        public RequestContext(@NonNull ProtectedMap dataModel, @Nullable String formAccessKey, @Nullable FontDTO defaultFont, @Nullable FontDTO defaultTableFont, @Nullable FontDTO defaultTableHeaderFont, @Nullable FontDTO defaultTableTitleFont, @Nullable ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern, @Nullable Map<String, LogicModelItem> logicModelItems) {
            this.dataModel = dataModel;
            Objects.requireNonNull(this.dataModel);
            this.formAccessKey = formAccessKey;
            this.defaultFont = defaultFont;
            this.defaultTableFont = defaultTableFont;
            this.defaultTableHeaderFont = defaultTableHeaderFont;
            this.defaultTableTitleFont = defaultTableTitleFont;
            this.defaultTableTitlePattern = defaultTableTitlePattern;
            this.logicModelItems = logicModelItems;
        }

        public @NonNull ProtectedMap getDataModel() {
            return this.dataModel;
        }

        public @Nullable String getFormAccessKey() {
            return this.formAccessKey;
        }

        public @Nullable FontDTO getDefaultFont() {
            return this.defaultFont;
        }

        public @Nullable FontDTO getDefaultTableFont() {
            return this.defaultTableFont;
        }

        public @Nullable FontDTO getDefaultTableHeaderFont() {
            return this.defaultTableHeaderFont;
        }

        public @Nullable FontDTO getDefaultTableTitleFont() {
            return this.defaultTableTitleFont;
        }

        public @Nullable ExpertDisplayInfoDTO.PatternDTO getDefaultTableTitlePattern() {
            return this.defaultTableTitlePattern;
        }

        public @Nullable Map<String, LogicModelItem> getLogicModelItems() {
            return this.logicModelItems;
        }

        public void setBarcodeLines(@Nullable List<?> barcodeLines) {
            this.barcodeLines = barcodeLines;
        }

        public @Nullable List<?> getBarcodeLines() {
            return this.barcodeLines;
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            HashMap<String, ExpertFormItem> formItems = null;
            ArrayList<ExpertNavigationItem> navigationItems = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertNavigationItem) {
                        if (navigationItems == null) {
                            navigationItems = new ArrayList<ExpertNavigationItem>();
                        }
                        navigationItems.add((ExpertNavigationItem)ref);
                        continue;
                    }
                    if (ref instanceof ExpertFormItem) {
                        if (formItems == null) {
                            formItems = new HashMap<String, ExpertFormItem>();
                        }
                        formItems.put(((ExpertFormItem)ref).getName(), (ExpertFormItem)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            return new ClassObjectPair(ExpertDisplayModel.class, (Object)new ExpertDisplayModel(formItems, navigationItems));
        }
    }
}

