/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.BooleanConverter;
import ch.dvbern.tax.common.transfer.dto.convert.ComboboxConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DateConverter;
import ch.dvbern.tax.common.transfer.dto.convert.DayMonthConverter;
import ch.dvbern.tax.common.transfer.dto.convert.FirstLetterConverter;
import ch.dvbern.tax.common.transfer.dto.convert.Float1Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float2Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float3Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float4Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float5Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float6Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float7Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float8Converter;
import ch.dvbern.tax.common.transfer.dto.convert.Float9Converter;
import ch.dvbern.tax.common.transfer.dto.convert.IntConverter;
import ch.dvbern.tax.common.transfer.dto.convert.IntSimpleConverter;
import ch.dvbern.tax.common.transfer.dto.convert.MonthYearConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import ch.dvbern.tax.common.transfer.dto.convert.PrintZeroConverter;
import ch.dvbern.tax.common.transfer.dto.convert.RadioConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextConverter;
import ch.dvbern.tax.common.transfer.dto.convert.TextareaConverter;
import ch.dvbern.tax.common.transfer.failure.InvalidModelItemKeyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.Validate;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ExpertDisplayUtil {
    private static long uiidIncrementer = 0L;
    private static final OptionItemDTO BLANK_ITEM = new OptionItemDTO(null, "", "", false);
    private static final String MAXLENGTH = "maxlength";
    private static final Map<String, ColorDTO> COLORS = new HashMap<String, ColorDTO>();
    private static final float DPI = 72.0f;
    private static final float PIXEL_TO_MM = 25.4f;

    private ExpertDisplayUtil() {
    }

    public static void registerColor(String name, ColorDTO color) {
        COLORS.put(name.toLowerCase(), color);
    }

    public static int toPixel(String mm) {
        if (mm == null || mm.isEmpty()) {
            return 0;
        }
        return ExpertDisplayUtil.toPixel(Float.parseFloat(mm));
    }

    public static float toPixelFloat(String mm) {
        if (mm == null || mm.isEmpty()) {
            return 0.0f;
        }
        return ExpertDisplayUtil.toPixelFloat(Float.parseFloat(mm));
    }

    public static int toPixel(float mm) {
        return Math.round(ExpertDisplayUtil.toPixelFloat(mm));
    }

    public static float toPixelFloat(float mm) {
        return mm / 25.4f * 72.0f;
    }

    public static float toMMFloat(float pixel) {
        return pixel * 25.4f / 72.0f;
    }

    public static ColorDTO parseColor(String color, ColorDTO def) {
        if (color == null || color.isEmpty()) {
            return def;
        }
        ColorDTO colorValue = null;
        if (color.startsWith("#")) {
            int r = Integer.parseInt(color.substring(1, 3), 16);
            int g = Integer.parseInt(color.substring(3, 5), 16);
            int b = Integer.parseInt(color.substring(5, 7), 16);
            colorValue = new ColorDTO(r, g, b);
        } else {
            colorValue = COLORS.get(color = color.toLowerCase());
            if (colorValue == null) {
                throw new RuntimeException("invalid color: '" + color + "'");
            }
        }
        return colorValue;
    }

    public static ColorDTO parseColor(String color) {
        return ExpertDisplayUtil.parseColor(color, null);
    }

    public static int parseHAlignment(String alignment) {
        if (alignment == null || alignment.isEmpty()) {
            return 0;
        }
        if ((alignment = alignment.toLowerCase()).equals("left")) {
            return 0;
        }
        if (alignment.equals("center")) {
            return 1;
        }
        if (alignment.equals("right")) {
            return 2;
        }
        throw new RuntimeException("invalid alignment: '" + alignment + "'");
    }

    public static int parseOutputMode(String mode) {
        return ExpertDisplayUtil.parseOutputMode(mode, 1);
    }

    public static int parseOutputMode(String mode, int def) {
        if (mode == null || mode.isEmpty()) {
            return def;
        }
        if ((mode = mode.toLowerCase()).equals("false") || mode.equals("nopage")) {
            return 0;
        }
        if (mode.equals("firstpage")) {
            return 1;
        }
        if (mode.equals("lastpage")) {
            return 2;
        }
        if (mode.equals("extrapages")) {
            return 4;
        }
        if (mode.equals("allpages")) {
            return 8;
        }
        throw new RuntimeException("invalid output mode: '" + mode + "'");
    }

    public static TypeAndConverter parseInputType(Element element, AbstractConverter<?> converter) throws ElementParserException {
        String inputType = element.getAttributeValue("type");
        TypeAndConverter result = new TypeAndConverter();
        if (inputType == null || inputType.isEmpty()) {
            int maxlength = 100;
            if (element.getAttribute(MAXLENGTH) != null) {
                maxlength = Integer.parseInt(element.getAttributeValue(MAXLENGTH));
            }
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(maxlength);
            return result;
        }
        if ((inputType = inputType.toLowerCase()).equals("text")) {
            int maxlength = 100;
            if (element.getAttribute(MAXLENGTH) != null) {
                maxlength = Integer.parseInt(element.getAttributeValue(MAXLENGTH));
            }
            result.type = 0;
            result.converter = converter != null ? converter : new TextConverter(maxlength);
        } else if (inputType.equals("textarea")) {
            int maxlength = 100;
            if (element.getAttribute(MAXLENGTH) != null) {
                maxlength = Integer.parseInt(element.getAttributeValue(MAXLENGTH));
            }
            String style = "";
            if (element.getAttribute("style") != null) {
                style = element.getAttribute("style");
            }
            result.type = 4;
            result.converter = converter != null ? converter : new TextareaConverter(maxlength, style);
        } else if (inputType.equals("int")) {
            result.type = 0;
            boolean printZeroIfReadonly = Boolean.valueOf(element.getAttributeValue("printZeroIfReadonly"));
            result.converter = converter != null ? converter : new IntConverter(11, printZeroIfReadonly);
        } else if (inputType.equals("float-1")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float1Converter(14, dynamicFP);
        } else if (inputType.equals("float-2")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float2Converter(14, dynamicFP);
        } else if (inputType.equals("float-3")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float3Converter(15, dynamicFP);
        } else if (inputType.equals("float-4")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float4Converter(16, dynamicFP);
        } else if (inputType.equals("float-5")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float5Converter(17, dynamicFP);
        } else if (inputType.equals("float-6")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float6Converter(18, dynamicFP);
        } else if (inputType.equals("float-7")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float7Converter(19, dynamicFP);
        } else if (inputType.equals("float-8")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float8Converter(20, dynamicFP);
        } else if (inputType.equals("float-9")) {
            boolean dynamicFP = Boolean.valueOf(element.getAttributeValue("dynamicFP"));
            result.type = 0;
            result.converter = converter != null ? converter : new Float9Converter(21, dynamicFP);
        } else if (inputType.equals("date")) {
            result.type = 0;
            result.converter = converter != null ? converter : new DateConverter();
        } else if (inputType.equals("boolean")) {
            result.type = 3;
            result.converter = converter != null ? converter : new BooleanConverter();
        } else if (inputType.equals("radio")) {
            result.type = 1;
            result.converter = converter != null ? converter : new RadioConverter();
        } else if (inputType.equals("combobox")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(false);
        } else if (inputType.equals("combobox-short")) {
            result.type = 2;
            result.converter = converter != null ? converter : new ComboboxConverter(true);
        } else if (inputType.equals("int-simple")) {
            result.type = 0;
            result.converter = converter != null ? converter : new IntSimpleConverter(11);
        } else if (inputType.equals("day-month")) {
            result.type = 0;
            result.converter = converter != null ? converter : new DayMonthConverter(element.getAttributeValue("year"), element.getAttributeValue("year-abs-ref"));
        } else if (inputType.equals("month-year")) {
            result.type = 0;
            result.converter = converter != null ? converter : new MonthYearConverter();
        } else if (inputType.equals("first-letter")) {
            result.type = 0;
            String s = element.getAttributeValue("chars");
            int chars = 1;
            if (s != null && !s.isEmpty()) {
                chars = Integer.parseInt(s);
            }
            result.converter = converter != null ? converter : new FirstLetterConverter(chars);
        } else {
            throw new RuntimeException("invalid alignment: '" + inputType + "'");
        }
        String printZero = element.getAttributeValue("printZero");
        if (printZero != null) {
            boolean flag;
            if (!(result.converter instanceof NumberConverter)) {
                throw new ElementParserException("Attribute 'printZero' may only be used with instances of NumberConverter.");
            }
            if (printZero.equalsIgnoreCase("true")) {
                flag = true;
            } else if (printZero.equalsIgnoreCase("false")) {
                flag = false;
            } else {
                throw new ElementParserException("Attribute 'printZero' must be either true or false.");
            }
            NumberConverter numberConverter = (NumberConverter)result.converter;
            result.converter = new PrintZeroConverter(numberConverter, flag);
        }
        return result;
    }

    public static int getShapeCount(String s) {
        int result = 0;
        int i = s.indexOf(35);
        while (i >= 0) {
            ++result;
            i = s.indexOf(35, i + 1);
        }
        return result;
    }

    public static String getModelItemKey(LogicModelItem lmi, String formKey) {
        try {
            StringBuilder result = new StringBuilder(lmi.getNameWithTableIndexShapes());
            int i = result.indexOf("#");
            StringTokenizer st = null;
            if (i >= 0) {
                int sharpPos = formKey.indexOf(35);
                if (sharpPos < 0) {
                    throw new InvalidModelItemKeyException("insufficient table indices in formKey");
                }
                st = new StringTokenizer(formKey.substring(sharpPos + 1), ".");
            }
            if (st != null) {
                while (i >= 0) {
                    if (!st.hasMoreTokens()) {
                        throw new InvalidModelItemKeyException("insufficient table indices in formKey. formKey=" + formKey);
                    }
                    result.replace(i, i + 1, st.nextToken());
                    i = result.indexOf("#");
                }
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new InvalidModelItemKeyException("Unexpected Exception on " + String.valueOf(lmi) + "/" + formKey, e);
        }
    }

    public static String getFormKeyWithoutTableIndizes(String formKey) {
        int i = formKey.indexOf(35);
        if (i >= 0) {
            return formKey.substring(0, i);
        }
        return formKey;
    }

    public static boolean isTableEntrySelected(int hierarchyLevel, Object currentTableEntryIndex, String formAccessKey) {
        String indices;
        StringTokenizer st;
        boolean result = false;
        int pos = formAccessKey.indexOf(35);
        if (pos >= 0 && hierarchyLevel < (st = new StringTokenizer(indices = formAccessKey.substring(pos + 1), ".")).countTokens()) {
            for (int i = 0; i < hierarchyLevel; ++i) {
                st.nextToken();
            }
            result = currentTableEntryIndex.toString().equals(st.nextToken());
        }
        return result;
    }

    public static boolean getBoolean(String s, boolean defaultValue) {
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static int getInt(String s, int defaultValue) {
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static float getFloat(String s, float defaultValue) {
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    public static String getString(String s, String defaultValue) {
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        return s;
    }

    public static Set<String> parseLanguages(String languages) {
        if (languages == null || languages.isEmpty()) {
            return null;
        }
        HashSet<String> langSet = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(languages, ",");
        while (st.hasMoreTokens()) {
            langSet.add(st.nextToken().toLowerCase());
        }
        return langSet;
    }

    public static void handleBlankItem(OptionItemsDTO optionItems, boolean blankItem) {
        if (optionItems == null) {
            return;
        }
        if (optionItems.isLocalized()) {
            for (String langcode : optionItems.getLanguageCodes()) {
                LinkedHashMap<Object, OptionItemDTO> opts = optionItems.getOptionItems(langcode);
                ExpertDisplayUtil.handleBlankItem(opts, blankItem);
            }
        } else {
            LinkedHashMap<Object, OptionItemDTO> options = optionItems.getOptionItems(null);
            ExpertDisplayUtil.handleBlankItem(options, blankItem);
        }
    }

    private static void handleBlankItem(LinkedHashMap<Object, OptionItemDTO> m, boolean blankItem) {
        m.remove(null);
        if (blankItem) {
            LinkedHashMap<Object, OptionItemDTO> newMap = new LinkedHashMap<Object, OptionItemDTO>();
            newMap.put(null, BLANK_ITEM);
            newMap.putAll(m);
            m.clear();
            m.putAll(newMap);
        }
    }

    public static Integer getDisabledOrTransparentParentState(LogicModelItem lmi, ExpertDisplayModel.ProtectedMap dataModel, String dmk) {
        LogicModelItem parentLMI = lmi.getParent();
        if (parentLMI != null) {
            String s = EngineUtil.mergeModelKey(parentLMI.getName(), dmk);
            ModelItemDTO miDTO = dataModel.get(s);
            if (miDTO != null) {
                if (miDTO.getState() == 12) {
                    return 12;
                }
                if (miDTO.getState() == 11) {
                    Integer parentState = ExpertDisplayUtil.getDisabledOrTransparentParentState(parentLMI, dataModel, dmk);
                    if (parentState != null && parentState == 12) {
                        return 12;
                    }
                    return 11;
                }
                return ExpertDisplayUtil.getDisabledOrTransparentParentState(parentLMI, dataModel, dmk);
            }
            return ExpertDisplayUtil.getDisabledOrTransparentParentState(parentLMI, dataModel, dmk);
        }
        return null;
    }

    public static DisplayItemUniqueID generateUniqueItemIdentifier(@NonNull String formName) {
        Validate.notEmpty((CharSequence)formName);
        return new DisplayItemUniqueID(formName, Long.toString(++uiidIncrementer));
    }

    static {
        COLORS.put("black", new ColorDTO(0, 0, 0));
        COLORS.put("white", new ColorDTO(255, 255, 255));
        COLORS.put("red", new ColorDTO(255, 0, 0));
        COLORS.put("green", new ColorDTO(0, 255, 0));
        COLORS.put("blue", new ColorDTO(0, 0, 255));
        COLORS.put("orange", new ColorDTO(255, 200, 0));
        COLORS.put("yellow", new ColorDTO(255, 255, 0));
        COLORS.put("magenta", new ColorDTO(255, 0, 255));
        COLORS.put("grey", new ColorDTO(182, 182, 182));
    }

    public static class TypeAndConverter {
        public int type;
        public AbstractConverter<?> converter;
    }
}

