/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertNavigationItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertFormItem
extends ExpertDisplayModelItem {
    private final String name;
    private final ExpertDisplayInfoDTO.PageSettingsDTO pageSettings;
    private final ExpertDisplayInfoDTO.PageSettingsDTO extraPagesSettings;
    private final FontDTO defaultFont;
    private final FontDTO defaultTableFont;
    private final FontDTO defaultTableHeaderFont;
    private final FontDTO defaultTableTitleFont;
    private final ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern;
    private final ExpertDisplayInfoDTO.ImageDTO guiBackground;
    private final ExpertDisplayInfoDTO.ImageDTO printBackground;
    private final ExpertDisplayInfoDTO.ImageDTO extraPagesBackground;
    private List<ExpertFormDisplayModelItem> formItems;
    private final int valuePrintPaddingX;
    private final int valuePrintPaddingY;
    private final boolean reverseWatermarkOverText;

    public ExpertFormItem(String name, ExpertDisplayInfoDTO.PageSettingsDTO pageSettings, ExpertDisplayInfoDTO.PageSettingsDTO extraPagesSettings, FontDTO defaultFont, FontDTO defaultTableFont, FontDTO defaultTableHeaderFont, FontDTO defaultTableTitleFont, ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern, ExpertDisplayInfoDTO.ImageDTO guiBackground, ExpertDisplayInfoDTO.ImageDTO printBackground, List<ExpertFormDisplayModelItem> formItems, ExpertDisplayInfoDTO.ImageDTO extraPagesBackground, int valuePrintPaddingX, int valuePrintPaddingY, boolean reverseWatermarkOverText) {
        super(null, 8, true);
        this.name = name;
        this.pageSettings = pageSettings;
        this.extraPagesSettings = extraPagesSettings;
        this.defaultFont = defaultFont;
        this.defaultTableFont = defaultTableFont == null ? defaultFont : defaultTableFont;
        this.defaultTableHeaderFont = defaultTableHeaderFont == null ? this.defaultTableFont : defaultTableHeaderFont;
        this.defaultTableTitleFont = defaultTableTitleFont == null ? this.defaultTableHeaderFont : defaultTableTitleFont;
        this.defaultTableTitlePattern = defaultTableTitlePattern;
        this.guiBackground = guiBackground;
        this.printBackground = printBackground;
        this.formItems = formItems;
        this.extraPagesBackground = extraPagesBackground;
        this.valuePrintPaddingX = valuePrintPaddingX;
        this.valuePrintPaddingY = valuePrintPaddingY;
        this.reverseWatermarkOverText = reverseWatermarkOverText;
        if (formItems != null) {
            for (ExpertDisplayModelItem expertDisplayModelItem : formItems) {
                expertDisplayModelItem.setParent(this);
            }
        }
    }

    public List<ExpertFormDisplayModelItem> getChildren() {
        return this.formItems;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
        if (this.name == null || this.name.isEmpty()) {
            throw new InvalidModelException("missing form item name in " + this.getClass().getName());
        }
        if (this.name.indexOf(46) != -1) {
            throw new InvalidModelException("invalid character (.) in expert form " + this.name);
        }
        if (this.name.indexOf(35) != -1) {
            throw new InvalidModelException("invalid character (#) in expert form " + this.name);
        }
        if (this.name.charAt(0) >= '0' && this.name.charAt(0) <= '9') {
            throw new InvalidModelException("invalid name (initial digit) in expert form " + this.name);
        }
        if (!navigationItems.containsKey(this.name)) {
            throw new InvalidModelException("missing navigation definition (" + this.name + ") in " + this.getClass().getName());
        }
        if (this.defaultFont == null && this.printBackground.getFileName() != null) {
            throw new InvalidModelException("missing default font definition (" + this.name + ") in " + this.getClass().getName());
        }
        if (this.formItems == null) {
            this.formItems = new ArrayList<ExpertFormDisplayModelItem>();
        }
    }

    public String getName() {
        return this.name;
    }

    public FontDTO getDefaultFont() {
        return this.defaultFont;
    }

    public FontDTO getDefaultTableFont() {
        return this.defaultTableFont;
    }

    public FontDTO getDefaultTableHeaderFont() {
        return this.defaultTableHeaderFont;
    }

    public FontDTO getDefaultTableTitleFont() {
        return this.defaultTableTitleFont;
    }

    public ExpertDisplayInfoDTO.PatternDTO getDefaultTableTitlePattern() {
        return this.defaultTableTitlePattern;
    }

    public ExpertDisplayInfoDTO getDTO(ExpertDisplayModel.RequestContext requestContext, List<ExpertNavigationItem> mainNavigationItems, Map<String, ExpertNavigationItem> allNavigationItems, Locale locale, int mode) {
        FastStack navigationPath = new FastStack();
        for (ExpertNavigationItem navItem = allNavigationItems.get(ExpertDisplayUtil.getFormKeyWithoutTableIndizes(requestContext.getFormAccessKey())); navItem != null; navItem = navItem.getParent()) {
            navigationPath.push(navItem);
        }
        ArrayList<ExpertDisplayInfoDTO.NavigationDTO> navigationItemDTOs = new ArrayList<ExpertDisplayInfoDTO.NavigationDTO>();
        for (ExpertNavigationItem element : mainNavigationItems) {
            ExpertNavigationItem eni = element;
            ExpertDisplayInfoDTO.NavigationDTO n = eni.getDTO(requestContext.getDataModel(), requestContext.getFormAccessKey(), new FastStack(), navigationPath, false);
            if (n == null) continue;
            navigationItemDTOs.add(n);
        }
        ArrayList<ExpertDisplayInfoDTO.ItemDTO> itemDTOs = new ArrayList<ExpertDisplayInfoDTO.ItemDTO>();
        for (ExpertFormDisplayModelItem fe : this.formItems) {
            ExpertDisplayInfoDTO.ItemDTO itemDTO;
            if (!fe.isEnabledForLanguage(locale) || !fe.isEnabledForMode(mode) || (itemDTO = fe.getItemDTO(requestContext)) == null) continue;
            itemDTOs.add(itemDTO);
        }
        return new ExpertDisplayInfoDTO(this.name, this.pageSettings, this.extraPagesSettings, itemDTOs, this.guiBackground, this.printBackground, navigationItemDTOs, this.extraPagesBackground, String.valueOf(this.getUniqueItemIdentifier()) + requestContext.getFormAccessKey(), requestContext.getFormAccessKey(), this.valuePrintPaddingX, this.valuePrintPaddingY, this.reverseWatermarkOverText);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ExpertFormDisplayModelItem> subItems = null;
            FontDTO defaultFont = null;
            FontDTO defaultTableFont = null;
            FontDTO defaultTableHeaderFont = null;
            FontDTO defaultTableTitleFont = null;
            ExpertDisplayInfoDTO.PatternDTO defaultTableTitlePattern = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertFormDisplayModelItem) {
                        if (subItems == null) {
                            subItems = new ArrayList<ExpertFormDisplayModelItem>();
                        }
                        subItems.add((ExpertFormDisplayModelItem)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        FontDTO font = (FontDTO)ref;
                        if (subElementName.equals("e-table-font")) {
                            defaultTableFont = font;
                            continue;
                        }
                        if (subElementName.equals("e-table-header-font")) {
                            defaultTableHeaderFont = font;
                            continue;
                        }
                        if (subElementName.equals("e-table-title-font")) {
                            defaultTableTitleFont = font;
                            continue;
                        }
                        defaultFont = font;
                        continue;
                    }
                    if (ref instanceof ExpertDisplayInfoDTO.PatternDTO) {
                        defaultTableTitlePattern = (ExpertDisplayInfoDTO.PatternDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            ExpertDisplayInfoDTO.ImageDTO extraPagesBackground = null;
            if (element.getAttributeValue("extraPagesPdf") != null) {
                extraPagesBackground = new ExpertDisplayInfoDTO.ImageDTO(0, 0, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), null, element.getAttributeValue("extraPagesPdf"), ExpertDisplayUtil.getInt(element.getAttributeValue("extraPagesPdfPage"), 0), 4, ExpertDisplayUtil.generateUniqueItemIdentifier(ExpertFormItem.class.getName()).appendLocal(".extraPagesPdf"));
            }
            ExpertFormItem efi = new ExpertFormItem(element.getAttributeValue("name"), new ExpertDisplayInfoDTO.PageSettingsDTO(ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginTop")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginBottom")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginLeft")), ExpertDisplayUtil.toPixel(element.getAttributeValue("marginRight"))), new ExpertDisplayInfoDTO.PageSettingsDTO(ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("extraPageMarginTop")), ExpertDisplayUtil.toPixel(element.getAttributeValue("extraPageMarginBottom")), ExpertDisplayUtil.toPixel(element.getAttributeValue("extraPageMarginLeft")), ExpertDisplayUtil.toPixel(element.getAttributeValue("extraPageMarginRight"))), defaultFont, defaultTableFont, defaultTableHeaderFont, defaultTableTitleFont, defaultTableTitlePattern, new ExpertDisplayInfoDTO.ImageDTO(0, 0, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), null, element.getAttributeValue("image"), 0, 0, ExpertDisplayUtil.generateUniqueItemIdentifier(ExpertFormItem.class.getName()).appendLocal(".hintergrundbildGUI")), new ExpertDisplayInfoDTO.ImageDTO(0, 0, ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), null, element.getAttributeValue("pdf"), ExpertDisplayUtil.getInt(element.getAttributeValue("pdfPage"), 0), 1, ExpertDisplayUtil.generateUniqueItemIdentifier(ExpertFormItem.class.getName()).appendLocal(".hintergrundbildPDF")), subItems, extraPagesBackground, ExpertDisplayUtil.toPixel(element.getAttributeValue("valuePrintPaddingX")), ExpertDisplayUtil.toPixel(element.getAttributeValue("valuePrintPaddingY")), ExpertDisplayUtil.getBoolean(element.getAttribute("reverseWatermarkOverText"), false));
            return new ClassObjectPair(ExpertNavigationItem.class, (Object)efi);
        }
    }
}

