/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertLabelAddOn
extends ExpertDisplayModelItem {
    private final String logicModelItemName;
    private LogicModelItem logicModelItem;
    private final AbstractConverter rendererAndInputValidator;

    public ExpertLabelAddOn(String logicModelItemName, AbstractConverter rendererAndInputValidator) {
        super(null, 8, true);
        this.logicModelItemName = logicModelItemName;
        this.rendererAndInputValidator = rendererAndInputValidator;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        if (this.logicModelItemName == null || logicModelItems.get(this.logicModelItemName) == null) {
            throw new InvalidModelException("invalid reference in: " + this.getClass().getName() + " value=" + this.logicModelItemName);
        }
        this.logicModelItem = logicModelItems.get(this.logicModelItemName);
    }

    public ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO getLabelAddOnDTO(ExpertDisplayModel.RequestContext requestContext) {
        return this.getLabelAddOnDTO(requestContext, requestContext.getFormAccessKey());
    }

    public ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO getLabelAddOnDTO(ExpertDisplayModel.RequestContext requestContext, String formAccessKey) {
        ModelItemDTO miDTO;
        String dmk = ExpertDisplayUtil.getModelItemKey(this.logicModelItem, formAccessKey);
        OptionItemsDTO optionItems = null;
        if (this.logicModelItem instanceof LogicModelItem.SelectItem) {
            optionItems = ((LogicModelItem.SelectItem)((Object)this.logicModelItem)).getOptionItems(requestContext.getDataModel(), dmk);
        }
        Object value = (miDTO = requestContext.getDataModel().get(dmk)) != null ? miDTO.getValue() : null;
        return new ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO(value, this.rendererAndInputValidator, optionItems);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            AbstractConverter converter = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof AbstractConverter) {
                        converter = (AbstractConverter)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            ExpertDisplayUtil.TypeAndConverter typeAndConverter = ExpertDisplayUtil.parseInputType(element, converter);
            return new ClassObjectPair(ExpertLabelAddOn.class, (Object)new ExpertLabelAddOn(element.getAttributeValue("value"), typeAndConverter.converter));
        }
    }
}

