/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertLinkItem
extends ExpertFormDisplayModelItem {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final String text;
    private final String formularKey;
    private final ColorDTO color;
    private final ColorDTO colorMouseOver;
    private final ColorDTO bgColor;
    private final FontDTO font;

    public ExpertLinkItem(int x, int y, int width, int height, String text, String formularKey, ColorDTO color, ColorDTO colorMouseOver, ColorDTO bgColor, FontDTO font, Set<String> languages) {
        super(languages, 0, true);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.text = text;
        this.formularKey = formularKey;
        this.color = color;
        this.colorMouseOver = colorMouseOver;
        this.bgColor = bgColor;
        this.font = font;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return null;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        return new ExpertDisplayInfoDTO.LinkItemDTO(this.x, this.y, this.width, this.height, this.text, this.formularKey, this.color, this.colorMouseOver, this.bgColor, this.font, this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            FontDTO font = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            ExpertLinkItem eli = new ExpertLinkItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), element.getAttributeValue("text"), element.getAttributeValue("formularKey"), ExpertDisplayUtil.parseColor(element.getAttributeValue("color")), ExpertDisplayUtil.parseColor(element.getAttributeValue("colorMouseOver")), ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), font, ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")));
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)eli);
        }
    }
}

