/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.oss.construct.xml.ClassObjectPair;
import ch.dvbern.oss.construct.xml.Element;
import ch.dvbern.oss.construct.xml.ElementParser;
import ch.dvbern.oss.construct.xml.ElementParserException;
import ch.dvbern.oss.construct.xml.ParserFactory;
import ch.dvbern.oss.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertListRowContent;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpertListItem
extends ExpertFormDisplayModelItem {
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int rowHeight;
    private final FontDTO font;
    private final ColorDTO bgColor;
    private final List<ExpertListRowContent> rows;
    private final int maxChars;

    public ExpertListItem(int x, int y, int width, int height, int rowHeight, FontDTO font, ColorDTO bgColor, List<ExpertListRowContent> rows, int printMode, Set<String> languages, int maxChars) {
        super(languages, printMode, false);
        if (height < rowHeight) {
            height = Integer.MAX_VALUE;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.rowHeight = rowHeight;
        this.font = font;
        this.bgColor = bgColor;
        this.rows = rows;
        this.maxChars = maxChars;
    }

    public List<ExpertListRowContent> getChildren() {
        return this.rows;
    }

    @Override
    protected void additionalInitialization(Map<String, LogicModelItem> logicModelItems, Map<String, ExpertFormItem> navigationItems) throws InvalidModelException {
        super.additionalInitialization(logicModelItems, navigationItems);
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO> rowDTOs = new ArrayList<ExpertDisplayInfoDTO.ListDTO.RowDTO>();
        for (ExpertListRowContent row : this.rows) {
            List<? extends ExpertDisplayInfoDTO.ListDTO.RowDTO> rowDTOList = row.getRowDTOs(requestContext);
            if (rowDTOList == null) continue;
            rowDTOs.addAll(rowDTOList);
        }
        return new ExpertDisplayInfoDTO.ListDTO(this.x, this.y, this.width, this.height, this.rowHeight, this.font != null ? this.font : requestContext.getDefaultFont(), this.bgColor, rowDTOs, this.getPrintMode(), this.getUniqueItemIdentifier(), this.maxChars);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ExpertListRowContent> rows = new ArrayList<ExpertListRowContent>();
            FontDTO font = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ExpertListRowContent) {
                        rows.add((ExpertListRowContent)ref);
                        continue;
                    }
                    if (ref instanceof FontDTO) {
                        font = (FontDTO)ref;
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            int maxChars = Integer.MAX_VALUE;
            if (element.getAttribute("maxChars") != null) {
                maxChars = Integer.parseInt(element.getAttributeValue("maxChars"));
            }
            ExpertListItem eli = new ExpertListItem(ExpertDisplayUtil.toPixel(element.getAttributeValue("x")), ExpertDisplayUtil.toPixel(element.getAttributeValue("y")), ExpertDisplayUtil.toPixel(element.getAttributeValue("width")), ExpertDisplayUtil.toPixel(element.getAttributeValue("height")), ExpertDisplayUtil.toPixel(element.getAttributeValue("rowHeight")), font, ExpertDisplayUtil.parseColor(element.getAttributeValue("bgColor")), rows, ExpertDisplayUtil.parseOutputMode(element.getAttributeValue("printItem")), ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")), maxChars);
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)eli);
        }
    }
}

